<?php

namespace App\Http\Requests;

use App\Models\VisitReimbursement;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreVisitReimbursementRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('visit_reimbursement_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'task_id' => [
                'integer',
                'exists:tasks,id',
                'nullable',
            ],
            'approved_by_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'visitReimbursement.approved_at' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
            'amount' => [
                'numeric',
                'nullable',
            ],
            'visit_id' => [
                'integer',
                'exists:employee_attendance_logs,id',
                'nullable',
            ],
            'status' => [
                'nullable',
                'in:' . implode(',', array_keys(VisitReimbursement::STATUS_RADIO)),
            ],
        ];
    }
}
