<?php

namespace App\Http\Requests;

use App\Models\ProductTaskEventLog;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreProductTaskEventLogRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('product_task_event_log_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'task_event_log_id' => [
                'integer',
                'exists:task_event_logs,id',
                'nullable',
            ],
            'product_id' => [
                'integer',
                'exists:products,id',
                'nullable',
            ],
            'quantity' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'status' => [
                'nullable',
                'in:' . implode(',', array_keys(ProductTaskEventLog::STATUS_SELECT)),
            ],
            'approved_by_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'productTaskEventLog.approved_at' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
        ];
    }
}
