<?php

namespace App\Http\Requests;

use App\Models\LedgerGroup;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreLedgerGroupRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('ledger_group_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'string',
                'nullable',
            ],
            'purpose' => [
                'string',
                'nullable',
            ],
        ];
    }
}
