<?php

namespace App\Http\Requests;

use App\Models\FinYr;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreFinYrRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('fin_yr_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'title' => [
                'string',
                'required',
                'unique:fin_yrs,title',
            ],
            'alias' => [
                'string',
                'nullable',
            ],
            'date_from' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'date_to' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
        ];
    }
}
