<?php

namespace App\Http\Requests;

use App\Models\ClientGroup;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreClientGroupRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('client_group_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'string',
                'nullable',
            ],
            'business_name' => [
                'string',
                'nullable',
            ],
            'address' => [
                'string',
                'nullable',
            ],
            'phone_1' => [
                'string',
                'nullable',
            ],
            'phone_2' => [
                'string',
                'nullable',
            ],
            'email_1' => [
                'string',
                'nullable',
            ],
            'email_2' => [
                'string',
                'nullable',
            ],
            'is_active' => [
                'boolean',
            ],
            'has_multi_state_business' => [
                'boolean',
            ],
            'zone' => [
                'array',
            ],
            'zone.*.id' => [
                'integer',
                'exists:zones,id',
            ],
            'state' => [
                'array',
            ],
            'state.*.id' => [
                'integer',
                'exists:states,id',
            ],
            'circle' => [
                'array',
            ],
            'circle.*.id' => [
                'integer',
                'exists:circles,id',
            ],
        ];
    }
}
