<?php

namespace App\Http\Requests;

use App\Models\ClientBranch;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreClientBranchRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('client_branch_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'string',
                'nullable',
            ],
            'address' => [
                'string',
                'nullable',
            ],
            'email' => [
                'string',
                'nullable',
            ],
            'phone' => [
                'string',
                'nullable',
            ],
            'phone_2' => [
                'string',
                'nullable',
            ],
            'region_id' => [
                'integer',
                'exists:regions,id',
                'nullable',
            ],
            'full_name' => [
                'string',
                'nullable',
            ],
            'latitude' => [
                'string',
                'nullable',
            ],
            'longitude' => [
                'string',
                'nullable',
            ],
            'solid_code' => [
                'string',
                'nullable',
            ],
        ];
    }
}
