<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  ...$guards
     * @return mixed
     */
    public function handle(Request $request, Closure $next, ...$guards)
    {
        $guards = empty($guards) ? [null] : $guards;

        // dd($guards);
        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {

                $user = Auth::guard($guard)->user();
                // dd($user);
                if ($user->isAdmin()) {
                    return redirect("/admin");
                }

                if ($user->isUser()) {
                    return redirect("/admin");
                }

                if ($user->isCircleOfficer()) {
                    return redirect("/circle-officer");
                }

                if ($user->isHeadEngineer()) {
                    return redirect("/engineer");
                }

                if ($user->isEngineer()) {
                    return redirect("/engineer");
                }

                if ($user->isClientOM()) {
                    return redirect("/client");
                }
                return redirect(RouteServiceProvider::HOME);
            }
        }

        return $next($request);
    }
}
