<?php

namespace App\Http\Middleware;

use App\Models\Role;
use App\Models\User;
use Closure;
use Illuminate\Support\Facades\Gate;

class AuthGates
{
    public function handle($request, Closure $next)
    {
        $user = auth()->user();

        if (!$user) {
            return $next($request);
        }

        $roles            = Role::with('permissions')->get();
        $permissionsArray = [];

        foreach ($roles as $role) {
            foreach ($role->permissions as $permissions) {
                $permissionsArray[$permissions->title][] = $role->id;
            }
        }

        foreach ($permissionsArray as $title => $roles) {
            Gate::define($title, function (User $user) use ($roles) {
                return count(array_intersect($user->roles->pluck('id')->toArray(), $roles)) > 0;
            });
        }


        // 'admin' => function (User $user) {
        //     return $user->isAdmin();
        // },
        // 'user' => function (User $user) {
        //     return $user->isUser();
        // },
        // 'circle-officer' => function (User $user) {
        //     return $user->isCircleOfficer();
        // },
        // 'zonal-officer' => function (User $user) {
        //     return $user->isZonalOfficer();
        // },
        // 'engineer' => function (User $user) {
        //     return $user->isEngineer();
        // },

        Gate::define('admin', function (User $user) {
            return $user->isAdmin();
        });
        Gate::define('user', function (User $user) {
            return $user->isUser();
        });
        Gate::define('circle-officer', function (User $user) {
            return $user->isCircleOfficer();
        });
        Gate::define('zonal-officer', function (User $user) {
            return $user->isZonalOfficer();
        });
        Gate::define('engineer', function (User $user) {
            return $user->isEngineer();
        });




        return $next($request);
    }
}
