<?php

namespace App\Http\Livewire\Zone;

use App\Models\State;
use App\Models\Zone;
use Livewire\Component;

class Create extends Component
{
    public Zone $zone;
    public array $listsForFields = [];

    public function mount(Zone $zone)
    {
        $this->zone            = $zone;
        $this->zone->is_active = true;
        $this->initListsForFields();
    }

    public function render()
    {

        return view('livewire.zone.create');
    }

    public function submit()
    {
        $this->validate();

        $this->zone->save();

        return redirect()->route('admin.zones.index');
    }

    protected function rules(): array
    {
        return [
            'zone.name' => [
                'string',
                'required',
            ],
            'zone.is_active' => [
                'boolean',
            ],
            'zone.state_id' => [
                'integer',
                'exists:states,id',
                'nullable',
            ],

        ];
    }


    protected function initListsForFields(): void
    {
        $this->listsForFields['states']   = State::pluck('name', 'id')->toArray();
    }
}
