<?php

namespace App\Http\Livewire\User;

use App\Models\Role;
use App\Models\User;
use Livewire\Component;

class Create extends Component
{
    public User $user;

    public array $roles = [];

    public string $password = '';

    public array $listsForFields = [];

    public function mount(User $user)
    {
        $this->user            = $user;
        $this->user->is_active = true;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.user.create');
    }

    public function submit()
    {
        $this->validate();
        $this->user->password = $this->password;
        $this->user->save();
        $this->user->roles()->sync($this->roles);

        return redirect()->route('admin.users.index');
    }

    protected function rules(): array
    {
        return [
            'user.name' => [
                'string',
                'required',
            ],
            'user.email' => [
                'email:rfc',
                'required',
                // 'unique:users,email',
                new \App\Rules\UniqueToMultipleFields('users', true, 'email', 'phone', 'username', 'employee_code'),
            ],
            'password' => [
                'string',
                'required',
            ],
            'roles' => [
                'required',
                'array',
            ],
            'roles.*.id' => [
                'integer',
                'exists:roles,id',
            ],
            'user.locale' => [
                'string',
                'nullable',
            ],
            'user.phone' => [
                'string',
                'nullable',
                new \App\Rules\UniqueToMultipleFields('users', true, 'email', 'phone', 'username', 'employee_code'),
            ],
            'user.username' => [
                'string',
                'nullable',
                new \App\Rules\UniqueToMultipleFields('users', true, 'email', 'phone', 'username', 'employee_code'),
            ],
            'user.employee_code' => [
                'string',
                'nullable',
                new \App\Rules\UniqueToMultipleFields('users', true, 'email', 'phone', 'username', 'employee_code'),
            ],
            'user.is_active' => [
                'boolean',
            ],
            'user.last_password_changed_at' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['roles'] = Role::pluck('title', 'id')->toArray();
    }
}
