<?php

namespace App\Http\Livewire\Task;

use App\Models\Task;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class TaskShowEngineer extends Component
{
    public Task $task;
    public User $user;
    public $can_assign_engineer = false;
    public $can_change_status = false;

    protected $listeners = ['taskModified' => 'refreshTask'];

    public function mount(Task $task)
    {
        $this->task = $task;
        // $task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');
        $this->loadData();
    }
    public function render()
    {
        return view('livewire.task.task-show-engineer');
    }

    public function addEngineerModal()
    {
    }

    public function refreshTask()
    {
        $this->loadData();
    }
    public function loadData()
    {
        $this->user = Auth::user();

        $this->can_assign_engineer = $this->user->isHeadEngineer();
        $this->can_change_status = true;
        $this->task->refresh();
        $this->task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');
    }
}
