<?php

namespace App\Http\Livewire\Task;

use App\Models\Circle;
use App\Models\CircleProductHistory;
use App\Models\ProductRequisition;
use App\Models\ProductTaskEventLog;
use App\Models\Task;
use App\Models\TaskEventLog;
use App\Models\TaskStatus;
use App\Models\User;
use Exception;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use LivewireUI\Modal\ModalComponent;

class CoTaskProductsModalComponent extends ModalComponent
{
    public Task $task;
    public User $user;
    public Circle $circle;
    public $description;
    public $productIdWiseStock = [];

    // public $accordion1Id = null;


    public  $engineers = [];
    public  $listsForFields = [
        'engineers' => []
    ];

    // public $assigned_to_id = null;
    // public $status_id = null;


    public static function modalMaxWidth(): string
    {
        return 'lg';
    }

    public function mount($taskId)
    {

        $productIds = [];
        $user = Auth::user();
        $task = Task::find($taskId);
        $task->load([
            'status', 'tag', 'assignedTo', 'clientGroup', 'client',
            'clientBranch',
            'circle',
            // 'clientBranch.circle',
            'taskEventLogs.loggedBy',
            // 'taskEventLogs.loggedBy',
            'taskEventLogs.assignedTo',
            'taskProductRequestLogs.all_products.product.media',
            'taskProductRequestLogs.loggedBy',
        ]);

        $this->task = $task;
        $this->user = $user;
        $this->circle = $task->circle;

        $task->taskProductRequestLogs->each(function ($d) {
            $d->all_products->each(function ($p) {
                $this->productIdWiseStock[$p->product_id] = 0;
            });
        });

        $this->loadProductStock(array_keys($this->productIdWiseStock));
        // dump($this->productIdWiseStock);


        // $this->engineers = (array) $user->engineers;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.task.co-task-products-modal-component', [
            'accordion1Id' => "accordx-" . uniqid(),
            'cStock' => function ($pid) {
                return $this->productIdWiseStock[$pid] ?? 0;
            }
        ]);
    }



    protected function initListsForFields(): void
    {
        // $this->listsForFields['engineers'] = $this->user->engineers->mapWithKeys(function ($d) {
        //     return [$d->id => $d->name_role];
        // });
        $this->listsForFields['status']        = TaskStatus::pluck('name', 'id')->toArray();
        // $this->listsForFields['tag']           = TaskTag::pluck('name', 'id')->toArray();
        // $this->listsForFields['assigned_to']   = User::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_group']  = ClientGroup::pluck('name', 'id')->toArray();
        // $this->listsForFields['client']        = Client::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_branch'] = ClientBranch::pluck('name', 'id')->toArray();
        // $this->listsForFields['call_type']     = $this->task::CALL_TYPE_RADIO;
    }


    protected function rules(): array
    {
        return [
            'task.status_id' => [
                'integer',
                'exists:task_statuses,id',
                'required',
            ],
            'description' => [
                'string',
                'nullable'
            ],
            // 'task.assigned_to_id' => [
            //     'integer',
            //     'exists:users,id',
            //     'required',
            // ],
        ];
    }

    public function submit()
    {
        $oldStatus = $this->task->status;
        $vals =  $this->validate();
        $this->task->update($vals['task']);
        $this->task->refresh()->load(['status']);
        TaskEventLog::createStatusChangedEvent(
            $this->task,
            auth()->user(),
            $this->description,
            $oldStatus,
            $this->task->status
        );
        $this->closeModalWithEvents([
            // UserOverview::getName() => ['userModified', [$this->user->id]],
            TaskShowEngineer::getName() => ['taskModified', [$this->task->id]]
        ]);
    }

    public function cancel()
    {
        $this->closeModalWithEvents([
            // UserOverview::getName() => ['userModified', [$this->user->id]],
        ]);
    }

    public function loadProductStock($productIds)
    {
        // $this->productIdWiseStock = [];
        $this->circle->load([
            'products' => function ($q) use ($productIds) {
                $q->whereIn('products.id', $productIds);
            }
        ]);
        $this->circle->products->each(function ($p) {
            $this->productIdWiseStock[$p->id] = $p->pivot->quantity;
        });
    }

    public function acceptProductRequest($productId, $productTaskEventLogId)
    {
        try {
            //code...
            $prodTaskLog = ProductTaskEventLog::find($productTaskEventLogId);
            // check if product quantity is available in circle
            if ($this->productIdWiseStock[$productId] >= $prodTaskLog->quantity) {
                $quantity_before = $this->productIdWiseStock[$productId];
                $stockToAdd = $prodTaskLog->quantity;
                $this->productIdWiseStock[$productId] - $prodTaskLog->quantity;


                // ProductZoneHistory
                CircleProductHistory::create([
                    'product_id' => $productId,
                    'circle_id' => $this->circle->id,
                    'quantity' => $stockToAdd,
                    'quantity_before' => $quantity_before,
                    // 'zone_id' => $this->zone_id,
                    // 'zone_quantity_before' => $zone_quantity_before,
                    'action' => 'removed',
                    'updated_by_id' => auth()->id(),
                ]);
                $prodTaskLog->update([
                    'status' => 'accepted'
                ]);



                $oldStatus = $this->task->status;
                // $vals =  $this->validate();
                $this->task->update([
                    'status_id' => TaskStatus::STATUS_PRODUCTS_SENT,
                ]);
                $this->task->refresh()->load(['status']);
                TaskEventLog::createStatusChangedEvent(
                    $this->task,
                    auth()->user(),
                    "Products Sent ",
                    $oldStatus,
                    $this->task->status
                );

                $this->dispatchBrowserEvent('alert', [
                    'type' => 'success',
                    'message' => "Products Sent "
                ]);
            } else {
                //
            }
        } catch (\Throwable $th) {
               report($th);
            $this->dispatchBrowserEvent('alert', [
                'type' => 'success',
                'message' => "Products requested "
            ]);
        }


        $this->forceClose()->closeModal();

        $this->closeModalWithEvents([
            TaskShowEngineer::getName() => ['taskModified', [$this->task->id]]
        ]);
    }

    public function requestProductToZonal($productId, $requestQuantity, ProductTaskEventLog $prodTaskLog)
    {
        // dump($productId, $requestQuantity,$prodTaskLog);
        // return;
        try {
            // throw new Exception("Error Processing Request", 1);
            $prodTaskLog = $prodTaskLog->refresh();
            $productId = !empty($productId) ? $productId : null;
            // create new ProductRequisition with $productId, $requestQuantity
            $pr = new ProductRequisition();
            if ($productId) {
                $pr->product_id = $productId;
                $pr->p_listed = true;
            } else {
                $pr->product_info = $prodTaskLog->info;
                // $pr->product_info = json_encode($prodTaskLog->info);
                $pr->p_listed = false;
            }
            $pr->product_task_event_log_id = $prodTaskLog->id;
            $pr->task_event_log_id = $prodTaskLog->task_event_log_id;
            $pr->requested_quantity = $requestQuantity;
            $pr->status = 'requested';
            // // $pr->requested_by = auth()->user()->id;
            // $pr->requested_by_type = auth()->user();
            // $pr->requested_to = $this->circle->zone;
            // $pr->requested_for = $this->circle;
            $pr->requestedBy()->associate(auth()->user());
            $pr->requestedTo()->associate($this->circle->zone);
            $pr->requestedFor()->associate($this->circle);
            $pr->save();
            // update product task event log status
            $prodTaskLog->update([
                'status' => 'requested'
            ]);

            ///


            $this->dispatchBrowserEvent('alert', [
                'type' => 'success',
                'message' => "Products requested "
            ]);
        } catch (\Throwable $th) {
               report($th);
            // dispatch browser error alert
            $this->dispatchBrowserEvent('alert', [
                'type' => 'error',
                'message' => "Something went wrong. " . $th->getMessage()
            ]);
        }

        $this->forceClose()->closeModal();

        $this->closeModalWithEvents([
            TaskShowEngineer::getName() => ['taskModified', [$this->task->id]]
        ]);
    }
}
