<?php

namespace App\Http\Livewire\SpecialPlannedDay;

use App\Models\SpecialPlannedDay;
use Livewire\Component;

class Create extends Component
{
    public array $listsForFields = [];

    public SpecialPlannedDay $specialPlannedDay;

    public function mount(SpecialPlannedDay $specialPlannedDay)
    {
        $this->specialPlannedDay             = $specialPlannedDay;
        $this->specialPlannedDay->leave_type = 'holiday';
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.special-planned-day.create');
    }

    public function submit()
    {
        $this->validate();

        $this->specialPlannedDay->save();

        return redirect()->route('admin.special-planned-days.index');
    }

    protected function rules(): array
    {
        return [
            'specialPlannedDay.title' => [
                'string',
                // 'required',
            ],
            'specialPlannedDay.description' => [
                'string',
                'nullable',
            ],
            'specialPlannedDay.leave_type' => [
                'required',
                'in:' . implode(',', array_keys($this->listsForFields['leave_type'])),
            ],
            'specialPlannedDay.from_date' => [
                'required',
                'date_format:' . config('project.date_format'),
            ],
            'specialPlannedDay.to_date' => [
                'required',
                'date_format:' . config('project.date_format'),
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['leave_type'] = $this->specialPlannedDay::LEAVE_TYPE_RADIO;
    }

    function updatedSpecialPlannedDayFromDate($value) {
        $this->specialPlannedDay->to_date = $value;
    }
}
