<?php

namespace App\Http\Livewire\Settings;

use App\Models\KVSetting;
use App\Models\Role;
use App\Models\User;
use Livewire\Component;

class PayrollSettingsComponent extends Component
{


    public $sett = [];


    // getPayrollFormulaVariables
    // setPayrollFormulaVariables

    public function mount(User $user)
    {
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.settings.payroll-settings-component');
    }

    public function submit()
    {
        // $this->validate();
        // $this->user->password = $this->password;
        // $this->user->save();
        // $this->user->roles()->sync($this->roles);
        KVSetting::setPayrollFormulaVariables($this->sett);


        // dispatch alert
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Settings updated successfully!'
        ]);
    }

    protected function rules(): array
    {
        return [
            "sett.ptax.above15k" => [
                'required',
                'number'
            ],
            "sett.ptax.10k15k" => [
                'required',
                'number'
            ],
            "sett.esi" => [
                'required',
                'number'
            ],
            "sett.pf" => [
                'required',
                'number'
            ],
            "sett.conveyance" => [
                'required',
                'number'
            ],
            "sett.hra" => [
                'required',
                'number'
            ],
            "sett.basic" => [
                'required',
                'number'
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->sett = KVSetting::getPayrollFormulaVariables();
    }
}
