<?php

namespace App\Http\Livewire\Purchase;

use App\Models\Purchase;
use Livewire\Component;

class Edit extends Component
{
    public Purchase $purchase;

    public array $listsForFields = [];

    public function mount(Purchase $purchase)
    {
        $this->purchase = $purchase;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.purchase.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->purchase->save();

        return redirect()->route('admin.purchases.index');
    }

    protected function rules(): array
    {
        return [
            'purchase.suply_invc_no' => [
                'string',
                'min:15',
                'nullable',
            ],
            'purchase.prchs_date' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'purchase.party_ac' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['party_ac'])),
            ],
            'purchase.total_invoic' => [
                'numeric',
                'nullable',
            ],
            'purchase.csgt_amt' => [
                'numeric',
                'nullable',
            ],
            'purchase.sgst_amt' => [
                'numeric',
                'nullable',
            ],
            'purchase.igst_amt' => [
                'numeric',
                'nullable',
            ],
            'purchase.invoice_total_wo_tax' => [
                'numeric',
                'nullable',
            ],
            'purchase.details' => [
                'string',
                'min:20',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['party_ac'] = $this->purchase::PARTY_AC_SELECT;
    }
}
