<?php

namespace App\Http\Livewire\ProductTaskEventLog;

use App\Models\Product;
use App\Models\ProductTaskEventLog;
use App\Models\TaskEventLog;
use App\Models\User;
use Livewire\Component;

class Create extends Component
{
    public array $listsForFields = [];

    public ProductTaskEventLog $productTaskEventLog;

    public function mount(ProductTaskEventLog $productTaskEventLog)
    {
        $this->productTaskEventLog         = $productTaskEventLog;
        $this->productTaskEventLog->status = 'Pending';
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.product-task-event-log.create');
    }

    public function submit()
    {
        $this->validate();

        $this->productTaskEventLog->save();

        return redirect()->route('admin.product-task-event-logs.index');
    }

    protected function rules(): array
    {
        return [
            'productTaskEventLog.task_event_log_id' => [
                'integer',
                'exists:task_event_logs,id',
                'nullable',
            ],
            'productTaskEventLog.product_id' => [
                'integer',
                'exists:products,id',
                'nullable',
            ],
            'productTaskEventLog.quantity' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'productTaskEventLog.status' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['status'])),
            ],
            'productTaskEventLog.approved_by_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'productTaskEventLog.approved_at' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['task_event_log'] = TaskEventLog::pluck('event_type', 'id')->toArray();
        $this->listsForFields['product']        = Product::pluck('name', 'id')->toArray();
        $this->listsForFields['status']         = $this->productTaskEventLog::STATUS_SELECT;
        $this->listsForFields['approved_by']    = User::pluck('name', 'id')->toArray();
    }
}
