<?php

namespace App\Http\Livewire\Modals\MonthlyPayslip;

use App\Models\EmployeeInfo;
use App\Models\FinYr;
use App\Models\KVSetting;
use App\Models\MonthlyPayslip;
use App\Models\User;
use Illuminate\Support\Arr;
use LivewireUI\Modal\ModalComponent;

class CreateModalComponent extends ModalComponent
{
    public array $listsForFields = [];
    public array $attribs = [];
    public array $lastUpdated = [];
    // public bool $isCreateMode = true;
    // public bool $isEditMode = false;
    // public bool $isViewMode = false;
    public  $mode = 'create';
    public MonthlyPayslip $monthlyPayslip;
    public User $user;
    public function mount($attribs = [], $monthlyPayslipId = null, $mode = 'create')
    {
        // $this->attribs = $attribs;
        $this->attribs = collect($attribs)->only(['fin_yr_id', 'year', 'month', 'user_id'])->toArray();
        // foreach ($attribs as $key => $value) {
        //     $this->monthlyPayslip->$key = $value;
        // }
        // $this->monthlyPayslip->year = Arr::get($attribs, 'year');
        // $this->monthlyPayslip->month = Arr::get($attribs, 'month');
        // /
        if ($monthlyPayslipId) {
            $this->monthlyPayslip =  MonthlyPayslip::find($monthlyPayslipId);
        } else {
            $this->monthlyPayslip = new MonthlyPayslip($this->attribs);
        }
        if (!in_array($mode, ["edit", "view"])) {
            $mode = 'create';
        }
        $this->mode = $mode;
        // $this->monthlyPayslip = $monthlyPayslip;
        $filters = Arr::except($this->attribs, ['user_id']);
        $this->user =  User::withExists([
            'employeeDetails as has_employee_info',
            'paySlips as is_payslip_generated' => function ($query) use ($filters) {
                return $query->where($filters);
            }
        ])
            ->with([
                'paySlips' => function ($query) use ($filters) {
                    $query->where($filters);
                },
            ])
            ->find($attribs['user_id']);
        $this->initListsForFields();
        $this->setEmployeeInfoToPaySlip();
        $this->calculateTotals();
    }

    public function setEmployeeInfoToPaySlip()
    {
        $employeeInfo = $this->user->employeeDetails;
        if ($employeeInfo) {
            $map = EmployeeInfo::mapEmployeeInfoToPaySlip();
            foreach ($map as $psKey => $empDetKey) {
                if (empty($this->monthlyPayslip->$psKey)) {
                    $this->monthlyPayslip->$psKey = $employeeInfo->$empDetKey;
                }
            }
        }
        //
        // empcode from user
        if (empty($this->monthlyPayslip->emp_code)) {
            $this->monthlyPayslip->emp_code = $this->user->employee_code;
        }
    }

    public function render()
    {
        return view('livewire.modals.monthly-payslip.create-modal-component');
    }

    public function submit()
    {
        $this->validate();

        $this->monthlyPayslip->save();
        $this->dispatchBrowserEvent('payslip-saved', [
            'payslip' => $this->monthlyPayslip,
        ]);
        $this->closeModal();

        // return redirect()->route('admin.monthly-payslips.index');
    }

    protected function rules(): array
    {
        return [
            'monthlyPayslip.fin_yr_id' => [
                'integer',
                'exists:fin_yrs,id',
                'nullable',
            ],
            'monthlyPayslip.year' => [
                'required',
                // 'in:' . implode(',', array_keys($this->listsForFields['year'])),
            ],
            'monthlyPayslip.month' => [
                'required',
                // 'in:' . implode(',', array_keys($this->listsForFields['month'])),
            ],
            'monthlyPayslip.user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'monthlyPayslip.emp_code' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.location' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.name' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.payment_mode' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.bank' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.bank_ac_no' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.aadhaar' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.blood_group' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.days_in_month' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'monthlyPayslip.lwp_days' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'monthlyPayslip.working_days' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'monthlyPayslip.esic_no' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.uan' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.basic_salary' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.hra' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.ta' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.incentive' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.total_earning' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.gross_salary' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.pf' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.ptax' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.esic' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.total_deduction' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.total_payment' => [
                // 'string',
                'nullable',
            ],
            'monthlyPayslip.payment_status' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['payment_status'])),
            ],
        ];
    }


    public function calculateTotals()
    {
        $totalMapper = [
            'total_payment' => [
                'total_earning' => [
                    'basic_salary',
                    'hra',
                    'ta',
                    'incentive',
                ],
                'total_deduction' => [
                    'pf',
                    'ptax',
                    'esic',
                ],
            ]
        ];
        $totalEarnings = 0;
        foreach ($totalMapper['total_payment']['total_earning'] as $key) {
            $totalEarnings += floatval($this->monthlyPayslip->$key);
        }
        $totalDeductions = 0;
        foreach ($totalMapper['total_payment']['total_deduction'] as $key) {
            $totalDeductions += floatval($this->monthlyPayslip->$key);
        }
        // $totalEarnings = rand(1111, 9999);
        // $totalDeductions = rand(1111, 9999);

        $this->monthlyPayslip->total_earning =  $totalEarnings;
        $this->monthlyPayslip->total_deduction = $totalDeductions;
        $this->monthlyPayslip->total_payment = $totalPayment = $totalEarnings - $totalDeductions;


        $this->monthlyPayslip->days_in_month = days_in_month($this->attribs['month'], $this->attribs['year']);
        $this->monthlyPayslip->working_days = floatval($this->monthlyPayslip->days_in_month) - floatval($this->monthlyPayslip->lwp_days);
    }

    public function updatedMonthlyPayslip($value, $key)
    {
        // $this->lastUpdated = compact('key', 'value');
        // $this->calculateTotals();
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['fin_yr']         = FinYr::pluck('title', 'id')->toArray();
        $this->listsForFields['year']           = MonthlyPayslip::getYearsSelectSequential();
        $this->listsForFields['month']          = MonthlyPayslip::getMonthsSelect();
        $this->listsForFields['user']           = User::pluck('name', 'id')->toArray();
        $this->listsForFields['payment_status'] = MonthlyPayslip::PAYMENT_STATUS_SELECT;
        // dump($this->listsForFields['year']);
    }


    public function cancel()
    {
        $this->dispatchBrowserEvent('payslip-saved', [
            // 'payslip' => $this->monthlyPayslip,
        ]);
        $this->closeModal();
    }

    #computed is_create_mode
    public function getIsCreateModeProperty()
    {
        return $this->mode == 'create';
    }
    #computed is_edit_mode
    public function getIsEditModeProperty()
    {
        return $this->mode == 'edit';
    }
    #computed is_view_mode
    public function getIsViewModeProperty()
    {
        return $this->mode == 'view';
    }

    public function generateFromFormula()
    {
        $sett = KVSetting::getPayrollFormulaVariables();
        // $sett = [
        //     "ptax" => ["above15k" => "4764", "10k15k" => "4"], "esi" => "476", "pf" => "476", "conveyance" => "76", "hra" => "467", "basic" => "465"
        // ];
        // sett is the percentage


        $basicPerc = floatval(Arr::get($sett, "basic"));
        $hraPerc = floatval(Arr::get($sett, "hra"));
        $conveyancePerc = floatval(Arr::get($sett, "conveyance"));
        $pfPerc = floatval(Arr::get($sett, "pf"));
        $esiPerc = floatval(Arr::get($sett, "esi"));
        $ptaxAbove15k = floatval(Arr::get($sett, "ptax.above15k"));
        $ptax10K15k = floatval(Arr::get($sett, "ptax.10k15k"));

        $grossWithIncentive = floatval($this->monthlyPayslip->gross_salary);
        $incentive = floatval($this->monthlyPayslip->incentive);
        $gross = $grossWithIncentive - $incentive;
        $basic = $gross * ($basicPerc / 100);
        $hra = $gross * ($hraPerc / 100);
        $conveyance = $gross * ($conveyancePerc / 100);
        $pf = $basic * ($pfPerc / 100);
        $esi = $gross * ($esiPerc / 100);
        $ptax = 0;
        if ($gross > 15000) {
            $ptax = $ptaxAbove15k;
        } elseif ($gross > 10000) {
            $ptax = $ptax10K15k;
        }

        $this->monthlyPayslip->basic_salary = $basic;
        $this->monthlyPayslip->hra = $hra;
        $this->monthlyPayslip->ta = $conveyance;
        $this->monthlyPayslip->pf = $pf;
        $this->monthlyPayslip->esic = $esi;
        $this->monthlyPayslip->ptax = $ptax;
        $this->monthlyPayslip->incentive = $incentive;

        // dump($this->monthlyPayslip->toArray(),compact('basic','hra','conveyance','pf','esi','ptax'));
        // return $this->render();


        $this->calculateTotals();
    }
}
