<?php

namespace App\Http\Livewire\LgAttributeValue;

use App\Models\LgAttribute;
use App\Models\LgAttributeValue;
use Livewire\Component;

class Create extends Component
{
    public array $listsForFields = [];

    public LgAttributeValue $lgAttributeValue;

    public function mount(LgAttributeValue $lgAttributeValue)
    {
        $this->lgAttributeValue     = $lgAttributeValue;
        $this->lgAttributeValue->so = '0';
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.lg-attribute-value.create');
    }

    public function submit()
    {
        $this->validate();

        $this->lgAttributeValue->save();

        return redirect()->route('admin.lg-attribute-values.index');
    }

    protected function rules(): array
    {
        return [
            'lgAttributeValue.ledger_group_attribute_id' => [
                'integer',
                'exists:lg_attributes,id',
                'nullable',
            ],
            'lgAttributeValue.value' => [
                'string',
                'nullable',
            ],
            'lgAttributeValue.so' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['ledger_group_attribute'] = LgAttribute::pluck('title', 'id')->toArray();
    }
}
