<?php

namespace App\Http\Livewire\LedgerTransaction;

use App\Models\FinYr;
use App\Models\Ledger;
use App\Models\LedgerTransaction;
use Livewire\Component;

class Create extends Component
{
    public array $listsForFields = [];

    public LedgerTransaction $ledgerTransaction;

    public function mount(LedgerTransaction $ledgerTransaction)
    {
        $this->ledgerTransaction = $ledgerTransaction;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.ledger-transaction.create');
    }

    public function submit()
    {
        $this->validate();

        $this->ledgerTransaction->save();

        return redirect()->route('admin.ledger-transactions.index');
    }

    protected function rules(): array
    {
        return [
            'ledgerTransaction.fin_yr_id' => [
                'integer',
                'exists:fin_yrs,id',
                'required',
            ],
            'ledgerTransaction.ledger_id' => [
                'integer',
                'exists:ledgers,id',
                'required',
            ],
            'ledgerTransaction.date' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
            'ledgerTransaction.amount' => [
                'numeric',
                'nullable',
            ],
            'ledgerTransaction.type' => [
                'required',
                'in:' . implode(',', array_keys($this->listsForFields['type'])),
            ],
            'ledgerTransaction.cr_bal_before' => [
                'numeric',
                'nullable',
            ],
            'ledgerTransaction.dr_bal_before' => [
                'numeric',
                'nullable',
            ],
            'ledgerTransaction.cr_bal_after' => [
                'numeric',
                'nullable',
            ],
            'ledgerTransaction.dr_bal_after' => [
                'numeric',
                'nullable',
            ],
            'ledgerTransaction.description' => [
                'string',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['fin_yr'] = FinYr::pluck('title', 'id')->toArray();
        $this->listsForFields['ledger'] = Ledger::pluck('name', 'id')->toArray();
        $this->listsForFields['type']   = $this->ledgerTransaction::TYPE_RADIO;
    }
}
