<?php

namespace App\Http\Livewire\LedgerLgAttributeValue;

use App\Models\Ledger;
use App\Models\LedgerLgAttributeValue;
use App\Models\LgAttribute;
use App\Models\LgAttributeValue;
use Livewire\Component;

class Edit extends Component
{
    public array $listsForFields = [];

    public LedgerLgAttributeValue $ledgerLgAttributeValue;

    public function mount(LedgerLgAttributeValue $ledgerLgAttributeValue)
    {
        $this->ledgerLgAttributeValue = $ledgerLgAttributeValue;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.ledger-lg-attribute-value.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->ledgerLgAttributeValue->save();

        return redirect()->route('admin.ledger-lg-attribute-values.index');
    }

    protected function rules(): array
    {
        return [
            'ledgerLgAttributeValue.ledger_id' => [
                'integer',
                'exists:ledgers,id',
                'nullable',
            ],
            'ledgerLgAttributeValue.lg_attribute_id' => [
                'integer',
                'exists:lg_attributes,id',
                'nullable',
            ],
            'ledgerLgAttributeValue.lg_attribute_value_id' => [
                'integer',
                'exists:lg_attribute_values,id',
                'nullable',
            ],
            'ledgerLgAttributeValue.value_text' => [
                'string',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['ledger']             = Ledger::pluck('name', 'id')->toArray();
        $this->listsForFields['lg_attribute']       = LgAttribute::pluck('title', 'id')->toArray();
        $this->listsForFields['lg_attribute_value'] = LgAttributeValue::pluck('value', 'id')->toArray();
    }
}
