<?php

namespace App\Http\Livewire\Ledger;

use App\Models\Ledger;
use App\Models\LedgerGroup;
use Livewire\Component;

class Edit extends Component
{
    public Ledger $ledger;

    public array $listsForFields = [];

    public function mount(Ledger $ledger)
    {
        $this->ledger = $ledger;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.ledger.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->ledger->save();

        return redirect()->route('admin.ledgers.index');
    }

    protected function rules(): array
    {
        return [
            'ledger.name' => [
                'string',
                'nullable',
            ],
            'ledger.description' => [
                'string',
                'nullable',
            ],
            'ledger.ledger_group_id' => [
                'integer',
                'exists:ledger_groups,id',
                'required',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['ledger_group'] = LedgerGroup::pluck('name', 'id')->toArray();
    }
}
