<?php

namespace App\Http\Livewire\JobDesignation;

use App\Models\JobDesignation;
use Livewire\Component;

class Edit extends Component
{
    public JobDesignation $jobDesignation;

    public function mount(JobDesignation $jobDesignation)
    {
        $this->jobDesignation = $jobDesignation;
    }

    public function render()
    {
        return view('livewire.job-designation.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->jobDesignation->save();

        return redirect()->route('admin.job-designations.index');
    }

    protected function rules(): array
    {
        return [
            'jobDesignation.title' => [
                'string',
                'nullable',
            ],
            'jobDesignation.description' => [
                'string',
                'nullable',
            ],
            'jobDesignation.basic_salary' => [
                'numeric',
                'nullable',
            ],
            'jobDesignation.basic_salary_max' => [
                'numeric',
                'nullable',
            ],
        ];
    }
}
