<?php

namespace App\Http\Livewire\FinYr;

use App\Models\FinYr;
use Livewire\Component;

class Edit extends Component
{
    public FinYr $finYr;

    public function mount(FinYr $finYr)
    {
        $this->finYr = $finYr;
    }

    public function render()
    {
        return view('livewire.fin-yr.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->finYr->save();

        return redirect()->route('admin.fin-yrs.index');
    }

    protected function rules(): array
    {
        return [
            'finYr.title' => [
                'string',
                'required',
                'unique:fin_yrs,title,' . $this->finYr->id,
            ],
            'finYr.alias' => [
                'string',
                'nullable',
            ],
            'finYr.date_from' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'finYr.date_to' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
        ];
    }
}
