<?php

namespace App\Http\Livewire\EmployeeInfo;

use App\Models\EmployeeInfo;
use App\Models\JobDesignation;
use App\Models\User;
use Livewire\Component;

class OldEdit extends Component
{
    public array $listsForFields = [];

    public EmployeeInfo $employeeInfo;

    public function mount(EmployeeInfo $employeeInfo)
    {
        $this->employeeInfo = $employeeInfo;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.employee-info.old-edit');
    }

    public function submit()
    {
        $this->validate();

        $this->employeeInfo->save();

        return redirect()->route('admin.employee-infos.index');
    }

    protected function rules(): array
    {
        return [
            'employeeInfo.user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'employeeInfo.first_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.middle_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.last_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.gender' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['gender'])),
            ],
            'employeeInfo.dob' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'employeeInfo.citizenship' => [
                'string',
                'nullable',
            ],
            'employeeInfo.age' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.religion' => [
                'string',
                'nullable',
            ],
            'employeeInfo.maritial_status' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['maritial_status'])),
            ],
            'employeeInfo.blood_group' => [
                'string',
                'nullable',
            ],
            'employeeInfo.email' => [
                'email:rfc',
                'nullable',
            ],
            'employeeInfo.present_address_line_1' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_line_2' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_line_3' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_line_4' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_district' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_pin' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_state' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_landmark' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_1' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_2' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_3' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_4' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_district' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_pin' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_state' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_landmark' => [
                'string',
                'nullable',
            ],
            'employeeInfo.personal_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_residence_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_residence_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_1_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_1_relation' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_1_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_2_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_2_relation' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_2_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.doj' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'employeeInfo.department' => [
                'string',
                'nullable',
            ],
            'employeeInfo.job_desgination_id' => [
                'integer',
                'exists:job_designations,id',
                'nullable',
            ],
            'employeeInfo.esic' => [
                'string',
                'nullable',
            ],
            'employeeInfo.uan' => [
                'string',
                'nullable',
            ],
            'employeeInfo.aadhaar' => [
                'string',
                'nullable',
            ],
            'employeeInfo.salary_ac_no' => [
                'string',
                'nullable',
            ],
            'employeeInfo.salary_ac_bank' => [
                'string',
                'nullable',
            ],
            'employeeInfo.salary_ac_ifsc' => [
                'string',
                'nullable',
            ],
            'employeeInfo.pm_basic_salary' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_hra' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_pf' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_esic' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_ptax' => [
                'numeric',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['user']            = User::pluck('name', 'id')->toArray();
        $this->listsForFields['gender']          = $this->employeeInfo::GENDER_RADIO;
        $this->listsForFields['maritial_status'] = $this->employeeInfo::MARITIAL_STATUS_SELECT;
        $this->listsForFields['job_desgination'] = JobDesignation::pluck('title', 'id')->toArray();
    }
}
