<?php

namespace App\Http\Livewire\CustomComponents\TreeViews;

use App\Http\Livewire\WithConfirmation;
use App\Http\Livewire\WithSorting;
use App\Models\Task;
use App\Models\User;
use App\Models\Zone;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;
use Livewire\Component;
use Livewire\WithPagination;

class ZoneTreeComponent extends Component
{
    use WithPagination;
    use WithSorting;
    use WithConfirmation;

    public int $perPage;
    private User $user;

    public array $orderable;

    public string $search = '';

    public array $selected = [];

    public array $paginationOptions;

    protected $queryString = [
        'search' => [
            'except' => '',
        ],
        'sortBy' => [
            'except' => 'id',
        ],
        'sortDirection' => [
            'except' => 'desc',
        ],
    ];

    public function getSelectedCountProperty()
    {
        return count($this->selected);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingPerPage()
    {
        $this->resetPage();
    }

    public function resetSelected()
    {
        $this->selected = [];
    }

    public function mount()
    {
        $this->sortBy            = 'id';
        $this->sortDirection     = 'desc';
        $this->perPage           = 100;
        $this->paginationOptions = config('project.pagination.options');
        $this->orderable         = (new Zone())->orderable;

        $this->user = User::getAuthUser();
    }

    public function render()
    {
        $query = Zone::query();
        // $query = $this->user->zones();

        $query->with([
            'state',
            'circles',
            'zonal_officer',
        ])->advancedFilter([
            's'               => $this->search ?: null,
            'order_column'    => $this->sortBy,
            'order_direction' => $this->sortDirection,
        ]);

        $zones = $query->paginate($this->perPage);
        $zones2 = $query->get();
        $zonesJson = $zones2->map(function ($zone) {
            return [
                'title' => $zone->name,
                'children' => $zone->circles->map(function ($circle) {
                    return [
                        'title' => $circle->name,
                        'children' => $circle->client_branches->map(function ($branch) {
                            return [
                                'title' => $branch->name,
                            ];
                        }),
                    ];
                }),
            ];
        });


        return view('livewire.custom-components.tree-views.zone-tree-component', compact('query', 'zones', 'zonesJson','zones2'));
    }

    public function deleteSelected()
    {
        abort_if(Gate::denies('task_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        Task::whereIn('id', $this->selected)->delete();

        $this->resetSelected();
    }

    public function delete(Task $task)
    {
        abort_if(Gate::denies('task_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $task->delete();
    }
}
