<?php

namespace App\Http\Livewire\Common;

use App\Models\ClientBranch;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\Task;
use App\Models\TaskStatus;
use Livewire\Component;
use LivewireUI\Modal\ModalComponent;

class TaskSearchForInvoiceModalComponent extends ModalComponent
{
    public array $listsForFields = [];
    public $branchIds = [];
    public $taskIds = [];
    public $clientGroupId;
    public $clientId;

    public $search = '';

    public function mount($clientGroupId, $clientId)
    {
        $this->clientGroupId = $clientGroupId;
        $this->clientId = $clientId;

        $this->initListsForFields();
    }


    public function render()
    {
        $pordQ = Task::query()->where(function ($q) {
            $q->where([
                'status_id' => TaskStatus::STATUS_CLOSED,
                'client_group_id' => $this->clientGroupId,
                'client_id' => $this->clientId,
                'is_invoiceable' => true,
                'o_invoice_id' => null,
            ]);
        });
        if ($this->search) {
            $pordQ->where(function ($q) {
                $q->where('name', 'like', '%' . $this->search . '%')
                    ->orWhere('description', 'like', '%' . $this->search . '%')
                    ->orWhere('incode', 'like', '%' . $this->search . '%')

                    //
                ;
            });
        }
        if (!empty($this->branchIds)) {
            $pordQ->where( function ($q) {
                $q->whereIn('client_branch_id', $this->branchIds);
            });
        }
        // // data[tasks]
        $data = [];
        if ($this->search) {
            $data['tasks'] = $pordQ->get();
        } else {
            $data['tasks'] = $pordQ->get();
            // $data['tasks'] = $pordQ->where('id', '-9')->get();
        }
        return view('livewire.common.task-search-for-invoice-modal-component', $data);
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['branches'] = ClientBranch::where([
            // 'client_group_id' => $this->clientGroupId,
            'client_id' => $this->clientId,
        ])->pluck('name', 'id')->toArray();
    }
    /**
     * Supported: 'sm', 'md', 'lg', 'xl', '2xl', '3xl', '4xl', '5xl', '6xl', '7xl'
     */
    public static function modalMaxWidth(): string
    {
        return '7xl';
    }
    public static function closeModalOnEscape(): bool
    {
        return false;
    }

    public function addProducts()
    {
        $this->emit('tasksSelected', $this->taskIds);
        $this->closeModal();
    }
}
