<?php

namespace App\Http\Livewire\CircleOfficer\Task;

use App\Http\Livewire\WithConfirmation;
use App\Http\Livewire\WithSorting;
use App\Models\ClientBranch;
use App\Models\Task;
use App\Models\User;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;
    use WithSorting;
    use WithConfirmation;

    public int $perPage;
    public User $user;

    public array $orderable;

    public string $search = '';

    public array $filters = [
        'circles' => [],
    ];
    public array $selected = [];
    public array $selected_circle_ids = [];
    public array $selected_branch_ids = [];
    public array $listsForFields = [];

    public array $paginationOptions;

    protected $queryString = [
        'search' => [
            'except' => '',
        ],
        'sortBy' => [
            'except' => 'id',
        ],
        'sortDirection' => [
            'except' => 'desc',
        ],
        'selected_circle_ids' => [
            'except' => null,
            'as' => 'cr',
        ],
        'selected_branch_ids' => [
            'except' => null,
            'as' => 'br',
        ],
    ];

    public function getSelectedCountProperty()
    {
        return count($this->selected);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingPerPage()
    {
        $this->resetPage();
    }

    public function resetSelected()
    {
        $this->selected = [];
    }

    public function mount()
    {
        $this->user = auth()->user();
        $this->sortBy            = 'id';
        $this->sortDirection     = 'desc';
        $this->perPage           = 100;
        $this->paginationOptions = config('project.pagination.options');
        $this->orderable         = (new Task())->orderable;

        $this->initListsForFields();
    }

    public function render()
    {
        $query = Task::with(['status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch', 'clientBranch.circle'])
            ->whereHas('clientBranch.circle', function ($qu2) {
                // $qu2->whereIn('id', $this->user->circles()->select('id')->pluck('id')->toArray());


                // all circles of user
                $allCirclesIds = array_keys($this->listsForFields['circles']);
                // if not empty selected_circle_ids then
                //  selectedFromAllCircles = intersection of allCirclesIds & selected_circle_ids
                // else
                //  selectedFromAllCircles = allCirclesIds
                $selectedFromAllCircles = empty($this->selected_circle_ids) ? $allCirclesIds : array_intersect($allCirclesIds, $this->selected_circle_ids);

                // selected circles of the user
                $qu2->whereIn('id', $selectedFromAllCircles);
            })
            ->whereHas('clientBranch', function ($qu2) {
                // $qu2->whereIn('id', $this->user->circles()->select('id')->pluck('id')->toArray());


                // all circles of user
                $allClientBranchIds = array_keys($this->listsForFields['client_branches']);
                // if not empty selected_circle_ids then
                //  selectedFromAllClientBranches = intersection of allCirclesIds & selected_circle_ids
                // else
                //  selectedFromAllClientBranches = allCirclesIds
                $selectedFromAllClientBranches = empty($this->selected_branch_ids) ? $allClientBranchIds : array_intersect($allClientBranchIds, $this->selected_branch_ids);

                // selected circles of the user
                $qu2->whereIn('id', $selectedFromAllClientBranches);
            })
            ->advancedFilter([
                's'               => $this->search ?: null,
                'order_column'    => $this->sortBy,
                'order_direction' => $this->sortDirection,
            ]);

        $tasks = $query->paginate($this->perPage);

        return view('livewire.circle-officer.task.index', compact('query', 'tasks'));
    }

    public function deleteSelected()
    {
        abort_if(Gate::denies('task_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        Task::whereIn('id', $this->selected)->delete();

        $this->resetSelected();
    }

    public function delete(Task $task)
    {
        abort_if(Gate::denies('task_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $task->delete();
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['circles'] = $this->user->circles()->pluck('name', 'id')->toArray();
        // if selected_circle_ids not empty  listsForFields['client_branches'] = ClientBranch::whereIn circle_id selected_circle_ids
        // else listsForFields['client_branches'] = ClientBranch::whereIn circle_id array_keys listsForFields['client_branches']
        $clientBranchQuery = ClientBranch::query();
        if (!empty($this->selected_circle_ids)) {
            $this->listsForFields['client_branches'] = $clientBranchQuery->whereIn('circle_id', $this->selected_circle_ids)->pluck('name', 'id')->toArray();
        } else {
            $this->listsForFields['client_branches'] = $clientBranchQuery->whereIn('circle_id', array_keys($this->listsForFields['circles']))->pluck('name', 'id')->toArray();
        }
    }

    public function updatedSelectedCircleIds($value, $key)
    {
        // dump(compact('value', 'key'));
        $this->initListsForFields();
        $this->reset([
            'selected_branch_ids',
        ]);
    }
}
