<?php

namespace App\Http\Livewire\Admin\VisitReimbursement;

use App\Models\VisitReimbursement;
use Livewire\Component;
use LivewireUI\Modal\ModalComponent;

class StatusChangeComponent extends ModalComponent
{
    public VisitReimbursement $visitReimbursement;
    public function render()
    {
        return view('livewire.admin.visit-reimbursement.status-change-component');
    }

    function mount($id)
    {
        $this->visitReimbursement = VisitReimbursement::find($id);
    }
    function changeStatusApprove()
    {
        $this->visitReimbursement->approved_at = now();
        $this->visitReimbursement->approved_by_id = auth()->user()->id;
        $this->visitReimbursement->status = 'approved';

        $this->visitReimbursement->save();
        $this->closeModalWithEvents([
            \App\Http\Livewire\Admin\VisitReimbursement\Show::class => ['visitReimbursementUpdated', [$this->visitReimbursement->id]]
        ]);
        // dispatch browser event alert success
        $this->dispatchBrowserEvent('alert', ['type' => 'success',  'message' => 'Reimbursement Approved!']);
    }
    function changeStatusUndoApprove()
    {
        $this->visitReimbursement->approved_at = null;
        $this->visitReimbursement->approved_by_id = null;
        $this->visitReimbursement->status = null;
        $this->visitReimbursement->save();
        $this->closeModalWithEvents([
            \App\Http\Livewire\Admin\VisitReimbursement\Show::class => ['visitReimbursementUpdated', [$this->visitReimbursement->id]]
        ]);
        // dispatch browser event alert success
        $this->dispatchBrowserEvent('alert', ['type' => 'success',  'message' => 'Reimbursement Un-Approved!']);
    }
}
