<?php

namespace App\Http\Livewire\Admin\Product;

use App\Models\Circle;
use App\Models\CircleProductHistory;
use App\Models\CircleProductPivot;
use App\Models\Product;
use App\Models\ProductZoneHistory;
use App\Models\ProductZonePivot;
use App\Models\User;
use App\Models\Zone;
use Livewire\Component;

class ZoneToCircleStockMoverComponent extends Component
{
    public array $listsForFields = [];

    // public Zone|null $selectedZone;
    public  $zone_id;
    public  $circle_id;
    public $state = [
        'stock' => [],
        'max' => [],

    ];
    protected $queryString = [
        'zone_id' => [
            'except' => null,
            'as' => 'zone',
        ],
        'circle_id' => [
            'except' => null,
            'as' => 'circle',
        ],
    ];


    public $stockMode = "add";

    public function addMode()
    {
        $this->stockMode = "add";
    }

    public function reduceMode()
    {
        $this->stockMode = "reduce";
    }
    public function setStockMode($val)
    {
        $val = strtolower($val);
        $val = in_array($val, ['add', 'reduce']) ? $val : 'add';
        $this->stockMode = $val;
        // dump($val);
    }

    public function resetStockMode()
    {
        $this->stockMode = "add";
    }


    public function mount()
    {

        // $this->productZonePivot->quantity = '0';
        $this->initListsForFields();
    }

    public function render()
    {
        $data = [];
        $zone = Zone::find($this->zone_id);
        $circle = null;
        $this->state['max'] = [];
        if ($zone) {
            $circle = $zone->circles()->find($this->circle_id);
            if ($circle) {
                // $data['products'] = Product::with([
                $data['products'] = $zone->products()->with([
                    'zones' => function ($query) {
                        $query->where('zone_id', $this->zone_id)
                            // ->select('id', 'name', 'stock')
                        ;
                    },
                    'circles' => function ($query) {
                        $query->where('circle_id', $this->circle_id)
                            // ->select('id', 'name', 'stock')
                        ;
                    },
                ])->get()
                    ->map(function ($product) {
                        $zone = ($product->zones->first());
                        $circle = ($product->circles->first());
                        $product->zoneStock = $zone ? $zone->pivot->quantity : 0;
                        $this->state['max'][$product->id] = $product->zoneStock;
                        $product->circleStock = $circle ? $circle->pivot->quantity : 0;
                        return $product;
                    });
            } else {

                $data['products'] = Product::where('id', '-9')->get();
                // reset circle_id
                $this->reset('circle_id');
            }
        } else {

            $data['products'] = Product::where('id', '-9')->get();
            // reset zone_id
            $this->reset('zone_id');
            $this->reset('circle_id');
        }
        $data['zone'] = $zone;
        $data['circle'] = $circle;

        return view('livewire.admin.product.zone-to-circle-stock-mover-component', $data);
    }

    public function submit()
    {
        // $this->validate();
        // $this->productZonePivot->save();

        // return redirect()->route('admin.product-zone-pivots.index');
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['product']         = Product::pluck('name', 'id')->toArray();
        $this->listsForFields['zone']            = Zone::pluck('name', 'id')->toArray();
        // $this->listsForFields['circle']          = [];
        $this->loadCircleList();
        $this->listsForFields['last_updated_by'] = User::pluck('name', 'id')->toArray();
    }

    public function loadCircleList()
    {
        $cq = Circle::query();
        if ($this->zone_id)
            $this->listsForFields['circle'] = $cq->where('zone_id', $this->zone_id)->pluck('name', 'id')->toArray();
        else
            $this->listsForFields['circle']          = [];
    }

    public function updatedZoneId($val, $key)
    {
        // dump(compact('val', 'key'));
        $this->state['stock'] = [];
        $this->circle_id = null;
        // $this->listsForFields['circle'] = Circle::where('zone_id', $this->zone_id)->pluck('name', 'id')->toArray();
        $this->loadCircleList();

        $this->resetErrorBag();
    }
    public function updatedCircleId($val, $key)
    {
        // dump(compact('val', 'key'));
        $this->state['stock'] = [];
        // $this->listsForFields['circle'] = Circle::where('zone_id', $this->zone_id)->pluck('name', 'id')->toArray();

        $this->resetErrorBag();
    }

    public function loadProducts()
    {
    }

    public function addStocks()
    {
        $user = auth()->user();
        $this->validate([
            'state.stock.*.add' => ['required', 'integer', 'min:0'],
        ], [
            'state.stock.*.add.required' => 'Please enter stock',
            'state.stock.*.add.integer' => 'Please enter valid stock',
            'state.stock.*.add.min' => 'Please enter valid stock',
        ]);
        $errors = 0;
        foreach ($this->state['stock'] as $key => $stock) {
            // if $stock['add] is greater than $this->state['max'][$key] add error
            if ($stock['add'] > $this->state['max'][$key]) {
                $this->addError('state.stock.' . $key . '.add', 'Please enter valid stock');
                $errors++;
            }
        }
        // dump($this->state['max']);
        if ($errors) {
            return;
        }
        // return;
        $productIds = array_keys($this->state['stock']);
        $productZonePivots = ProductZonePivot::whereIn('product_id', $productIds)
            ->where('zone_id', $this->zone_id)->get();
        $circleProductPivots = CircleProductPivot::whereIn('product_id', $productIds)
            ->where('circle_id', $this->circle_id)->get();

        $totalAdd = 0;
        foreach ($this->state['stock'] as $key => $stock) {
            $productZonePivot = $productZonePivots->where('product_id', $key)
                ->where('zone_id', $this->zone_id)
                ->first();
            $circleProductPivot = $circleProductPivots->where('product_id', $key)
                ->where('circle_id', $this->circle_id)
                ->first();
            $zone_quantity_before = $productZonePivot->quantity;
            $quantity_before = 0;
            $stockToAdd = $stock['add'];
            if ($stockToAdd > 0) {

                if ($circleProductPivot) {
                    $quantity_before = $circleProductPivot->quantity;
                    $circleProductPivot->quantity += $stockToAdd;
                    $circleProductPivot->save();
                } else {
                    CircleProductPivot::create([
                        'product_id' => $key,
                        // 'zone_id' => $this->zone_id,
                        'circle_id' => $this->circle_id,
                        'quantity' => $stockToAdd,
                    ]);
                }
                $productZonePivot->quantity -= $stockToAdd;
                $productZonePivot->save();

                // ProductZoneHistory
                ProductZoneHistory::create([
                    'product_id' => $key,
                    'zone_id' => $this->zone_id,
                    'quantity' => $stockToAdd,
                    'quantity_before' => $zone_quantity_before,
                    'action' => 'removed',
                    'updated_by_id' => auth()->id(),
                ]);
                // ProductZoneHistory
                CircleProductHistory::create([
                    'product_id' => $key,
                    'circle_id' => $this->circle_id,
                    'quantity' => $stockToAdd,
                    'quantity_before' => $quantity_before,
                    'zone_id' => $this->zone_id,
                    'zone_quantity_before' => $zone_quantity_before,
                    'action' => 'add',
                    'updated_by_id' => auth()->id(),
                ]);
                $totalAdd += $stockToAdd;
            }
        }
        $this->state['stock'] = [];

        if ($totalAdd) {
            // dispatch success alert
            $this->dispatchBrowserEvent('alert', [
                'type' => 'success',
                'message' => 'Stock added successfully',
            ]);
        }
    }


    public function reduceStocks()
    {
        $user = auth()->user();
        $this->validate([
            'state.stock.*.reduce' => ['required', 'integer', 'min:0'],
        ], [
            'state.stock.*.reduce.required' => 'Please enter stock',
            'state.stock.*.reduce.integer' => 'Please enter valid stock',
            'state.stock.*.reduce.min' => 'Please enter valid stock',
        ]);
        $errors = 0;
        foreach ($this->state['stock'] as $key => $stock) {
            // if $stock['add] is greater than $this->state['max'][$key] add error
            if ($stock['reduce'] <= $this->state['max'][$key]) {
                $this->addError('state.stock.' . $key . '.reduce', 'Please enter valid stock');
                $errors++;
            }
        }
        // dump($this->state['max']);
        if ($errors) {
            return;
        }
        // return;
        $productIds = array_keys($this->state['stock']);
        $productZonePivots = ProductZonePivot::whereIn('product_id', $productIds)
            ->where('zone_id', $this->zone_id)->get();
        $circleProductPivots = CircleProductPivot::whereIn('product_id', $productIds)
            ->where('circle_id', $this->circle_id)->get();

        $totalAdd = 0;
        foreach ($this->state['stock'] as $key => $stock) {
            $productZonePivot = $productZonePivots->where('product_id', $key)
                ->where('zone_id', $this->zone_id)
                ->first();
            $circleProductPivot = $circleProductPivots->where('product_id', $key)
                ->where('circle_id', $this->circle_id)
                ->first();
            $zone_quantity_before = $productZonePivot->quantity;
            $quantity_before = 0;
            $stockToAdd = $stock['reduce'];
            if ($stockToAdd > 0) {

                if ($circleProductPivot) {
                    $quantity_before = $circleProductPivot->quantity;
                    $circleProductPivot->quantity -= $stockToAdd;
                    $circleProductPivot->save();
                } else {
                    // CircleProductPivot::create([
                    //     'product_id' => $key,
                    //     // 'zone_id' => $this->zone_id,
                    //     'circle_id' => $this->circle_id,
                    //     'quantity' => $stockToAdd,
                    // ]);
                }
                $productZonePivot->quantity += $stockToAdd;
                $productZonePivot->save();

                // ProductZoneHistory
                ProductZoneHistory::create([
                    'product_id' => $key,
                    'zone_id' => $this->zone_id,
                    'quantity' => $stockToAdd,
                    'quantity_before' => $zone_quantity_before,
                    'action' => 'removed',
                    'updated_by_id' => auth()->id(),
                ]);
                // ProductZoneHistory
                CircleProductHistory::create([
                    'product_id' => $key,
                    'circle_id' => $this->circle_id,
                    'quantity' => $stockToAdd,
                    'quantity_before' => $quantity_before,
                    'zone_id' => $this->zone_id,
                    'zone_quantity_before' => $zone_quantity_before,
                    'action' => 'reduce',
                    'updated_by_id' => auth()->id(),
                ]);
                $totalAdd += $stockToAdd;
            }
        }
        $this->state['stock'] = [];

        if ($totalAdd) {
            // dispatch success alert
            $this->dispatchBrowserEvent('alert', [
                'type' => 'success',
                'message' => 'Stock reduced successfully',
            ]);
        }
    }



    // protected function rules(): array
    // {
    //     return [
    //         'productZonePivot.product_id' => [
    //             'integer',
    //             'exists:products,id',
    //             'nullable',
    //         ],
    //         'productZonePivot.zone_id' => [
    //             'integer',
    //             'exists:zones,id',
    //             'nullable',
    //         ],
    //         'productZonePivot.quantity' => [
    //             'integer',
    //             'min:-2147483648',
    //             'max:2147483647',
    //             'nullable',
    //         ],
    //         'productZonePivot.price' => [
    //             'numeric',
    //             'nullable',
    //         ],
    //         'productZonePivot.last_updated_by_id' => [
    //             'integer',
    //             'exists:users,id',
    //             'nullable',
    //         ],
    //     ];
    // }
}
