<?php

namespace App\Http\Livewire\Admin\Invoices;

use App\Models\Client;
use App\Models\CircleProductHistory;
use App\Models\CircleProductPivot;
use App\Models\Product;
use App\Models\ProductZoneHistory;
use App\Models\ProductZonePivot;
use App\Models\User;
use App\Models\ClientGroup;
use App\Models\OInvoice;
use App\Models\OInvoiceItem;
use App\Models\Service;
use App\Models\Task;
use Illuminate\Support\Arr;
use LaravelDaily\Invoices\InvoiceServiceProvider;
use Livewire\Component;

class CreateInvoiceComponent extends Component
{
    public array $listsForFields = [];

    private OInvoice|null $invoice = null;
    // public ClientGroup|null $selectedZone;
    public  $invoice_id;
    public  $client_group_id;
    public  $client_id;
    public  $invoice_date;
    public  $due_date;
    public  $inv_type;
    public  $invoiceItems = [];
    public  $deleted_item_ids = [];
    public  $extra_inv_data = [];
    public $state = [
        'stock' => [],
        'max' => [],

    ];
    protected $queryString = [
        // 'client_group_id' => [
        //     'except' => null,
        //     'as' => 'clientGroup',
        // ],
        // 'client_id' => [
        //     'except' => null,
        //     'as' => 'client',
        // ],
    ];

    protected $listeners = [
        'productsSelected' => 'onProductsSelected',
        'tasksSelected' => 'onTasksSelected',
        'servicesSelected' => 'onServicesSelected',
    ];
    public OInvoice|null $oldInvoice = null;



    public function mount(OInvoice $invoice = null)
    {

        // $this->productZonePivot->quantity = '0';
        if ($invoice) {
            $this->invoice = $invoice;
            $this->invoice_id = $invoice->id;
            $this->client_group_id = $invoice->client_group_id;
            $this->client_id = $invoice->client_id;
            $this->invoice_date = $invoice->date_f;
            $this->due_date = $invoice->due_date_f;
            $this->inv_type = $invoice->inv_type;
            $this->extra_inv_data = $invoice->only([
                'party_name'
            ]);


            $this->invoiceItems = $invoice->items->map(function (OInvoiceItem $item) {
                // 'name', 'description', 'price', 'quantity', 'discount', 'subtotal', 'total',
                // 'tax_amount',  'type',
                // 'hsn_code', 'taxable_price', 'gst_rate', 'cgst_rate', 'sgst_rate', 'igst_rate',
                // 'gst_amount', 'cgst_amount', 'sgst_amount', 'igst_amount'
                $data = [
                    'id' => $item->id,
                    'name' => $item->name,
                    'description' => $item->description,
                    'quantity' => $item->quantity,
                    'price' => $item->price,
                    'discount' => $item->discount,
                    'total' => $item->total,
                    'gst_rate' => $item->gst_rate,
                    'cgst_rate' => $item->cgst_rate,
                    'sgst_rate' => $item->sgst_rate,
                    'igst_rate' => $item->igst_rate,
                    'gst_amount' => $item->gst_amount,
                    'cgst_amount' => $item->cgst_amount,
                    'sgst_amount' => $item->sgst_amount,
                    'igst_amount' => $item->igst_amount,
                    'price_o' => $item->taxable_price,
                    'taxable_price' => $item->taxable_price,
                    'hsn_code' => $item->hsn_code,
                    'type' => $item->type,
                    'tax_amount' => $item->tax_amount,
                    'subtotal' => $item->subtotal,

                ];
                if ($item->isProduct()) {
                    $data['product_id'] = $item->invoiceable_id;
                }
                if ($item->isService()) {
                    $data['service_id'] = $item->invoiceable_id;
                }
                if ($item->isTask()) {
                    $data['task_id'] = $item->invoiceable_id;
                }
                return $data;
            })->toArray();
        } else {
            $this->invoice_date = now()->format('d-m-Y');
            $this->due_date = now()->addDays(15)->format('d-m-Y');
            $this->inv_type = OInvoice::INV_TYPE_TASK;
        }


        $this->initListsForFields();
    }

    public function render()
    {
        $data = [];
        $clientGroup = ClientGroup::find($this->client_group_id);
        $client = null;
        $this->state['max'] = [];
        if ($clientGroup) {
            $client = $clientGroup->clients()->find($this->client_id);
            if ($client) {
                $data['products'] = Product::where('id', '-9')->get();
            } else {

                $data['products'] = Product::where('id', '-9')->get();
                // reset client_id
                $this->reset('client_id');
            }
        } else {

            $data['products'] = Product::where('id', '-9')->get();
            // reset client_group_id
            $this->reset('client_group_id');
            $this->reset('client_id');
        }
        $data['clientGroup'] = $clientGroup;
        $data['client'] = $client;
        $data['isUpdateMode'] = $this->invoice_id ? true : false;
        // $data['invoice'] = $this->invoice;

        return view('livewire.admin.invoices.create-invoice-component', $data);
    }

    public function submit()
    {
        // $this->validate();
        // $this->productZonePivot->save();

        // return redirect()->route('admin.product-clientGroup-pivots.index');
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['product']         = Product::pluck('name', 'id')->toArray();
        $this->listsForFields['clientGroup']            = ClientGroup::pluck('name', 'id')->toArray();
        // $this->listsForFields['client']          = [];
        $this->loadCircleList();
        $this->listsForFields['last_updated_by'] = User::pluck('name', 'id')->toArray();
        $this->listsForFields['inv_types'] = OInvoice::INV_TYPES;
    }

    public function loadCircleList()
    {
        $cq = Client::query();
        if ($this->client_group_id)
            $this->listsForFields['client'] = $cq->where('client_group_id', $this->client_group_id)->pluck('name', 'id')->toArray();
        else
            $this->listsForFields['client']          = [];
    }

    public function updatedClientGroupId($val, $key)
    {
        // dump(compact('val', 'key'));
        $this->state['stock'] = [];
        $this->client_id = null;
        // $this->listsForFields['client'] = Client::where('client_group_id', $this->client_group_id)->pluck('name', 'id')->toArray();
        $this->loadCircleList();

        $this->resetErrorBag();
    }
    public function updatedClientId($val, $key)
    {
        // dump(compact('val', 'key'));
        $this->state['stock'] = [];
        // $this->listsForFields['client'] = Client::where('client_group_id', $this->client_group_id)->pluck('name', 'id')->toArray();

        $this->resetErrorBag();
    }

    public function loadProducts()
    {
    }

    public function addStocks()
    {
        $user = auth()->user();
        $this->validate([
            'state.stock.*.add' => ['required', 'integer', 'min:1'],
        ], [
            'state.stock.*.add.required' => 'Please enter stock',
            'state.stock.*.add.integer' => 'Please enter valid stock',
            'state.stock.*.add.min' => 'Please enter valid stock',
        ]);


        // dispatch success alert
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Stock added successfully',
        ]);
    }

    public function onProductsSelected($productIds)
    {
        $products = Product::whereIn('id', $productIds)->get();
        foreach ($productIds as $key => $pid) {
            $product = $products->where('id', $pid)->first();
            // price total  hsn_code gst_rate cgst_rate sgst_rate igst_rate taxable_price
            $this->invoiceItems[] = [
                'product_id' => $product->id,
                'name' => $product->name,
                'description' => $product->description,
                'quantity' => 1,
                'price_o' => $product->price,
                'price' => $product->price,
                'total' => $product->price,
                'hsn_code' => $product->hsn_code,
                'gst_rate' => $product->gst_rate,
                'cgst_rate' => $product->cgst_rate,
                'sgst_rate' => $product->sgst_rate,
                'igst_rate' => $product->igst_rate,
                'taxable_price' => $product->taxable_price,
                'type' => 'product',
            ];
        }
        // $this->invoiceItems[] = [];
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Products Selected',
        ]);
    }

    public function onServicesSelected($productIds)
    {
        $products = Service::whereIn('id', $productIds)->get();
        foreach ($productIds as $key => $pid) {
            $product = $products->where('id', $pid)->first();
            // price total  hsn_code gst_rate cgst_rate sgst_rate igst_rate taxable_price
            $this->invoiceItems[] = [
                'service_id' => $product->id,
                'name' => $product->name,
                'description' => $product->description,
                'quantity' => 1,
                'price_o' => $product->price,
                'price' => $product->price,
                'total' => $product->price,
                'hsn_code' => $product->hsn_code,
                'gst_rate' => $product->gst_rate,
                'cgst_rate' => $product->cgst_rate,
                'sgst_rate' => $product->sgst_rate,
                'igst_rate' => $product->igst_rate,
                'taxable_price' => $product->taxable_price,
                'type' => 'service',
            ];
        }
        // $this->invoiceItems[] = [];
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Services Selected',
        ]);
    }

    public function onTasksSelected($taskIds)
    {
        // check if taskIds are already in invoiceItems
        $existingTaskIds = collect($taskIds)->diff(collect($this->invoiceItems)->where('type', 'task')->pluck('task_id'))->all();
        if (count($existingTaskIds) != count($taskIds)) {
            $this->dispatchBrowserEvent('alert', [
                'type' => 'error',
                'message' => 'Some tasks are already selected',
            ]);
            return;
        }
        // dump(compact('taskIds'));


        $tasks = Task::whereIn('id', $taskIds)->get();
        foreach ($taskIds as $key => $tids) {
            $task = $tasks->where('id', $tids)->first();
            // price total  hsn_code gst_rate cgst_rate sgst_rate igst_rate taxable_price
            $this->invoiceItems[] = [
                'task_id' => $task->id,
                'name' => $task->name,
                'description' => $task->description,
                'quantity' => 1,
                'price_o' => $task->amount_wo_gst,
                'price' => $task->amount_wo_gst,
                'total' => $task->amount_w_gst,
                'hsn_code' => $task->hsn_code,
                'gst_rate' => $task->igst_rate,
                'cgst_rate' => $task->cgst_rate,
                'sgst_rate' => $task->sgst_rate,
                'igst_rate' => $task->igst_rate,
                'taxable_price' => $task->amount_wo_gst,
                'type' => 'task',
            ];
        }
        // $this->invoiceItems[] = [];
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Tickets Selected',
        ]);
    }

    public function updatedInvoiceItems($value, $key)
    {
        [$itemIndex, $field] = explode(".", $key);
        // gst_rate taxable_price
        if ($field == 'quantity') {
            $this->updateByQuantity($itemIndex, $value);
        } elseif ($field == 'taxable_price') {
            $this->updateByPrice($itemIndex, $value);
        } elseif ($field == 'gst_rate') {
            $this->updateByTax($itemIndex, $value);
        }
    }

    public function updateByQuantity($itemIndex, $qty)
    {
        $this->invoiceItems[$itemIndex]['quantity'] = $qty;
        $this->calculateSubTotal($itemIndex);
    }

    public function removeItem($itemIndex)
    {
        // check if row id
        if (isset($this->invoiceItems[$itemIndex]['id'])) {
            // $this->invoiceItems[$itemIndex]['_delete'] = true;
            $this->deleted_item_ids[] = $this->invoiceItems[$itemIndex]['id'];
        }

        unset($this->invoiceItems[$itemIndex]);
        $this->invoiceItems = array_values($this->invoiceItems);
    }

    public function updateByPrice($itemIndex, $price)
    {
        $this->invoiceItems[$itemIndex]['price'] = $price;
        // $this->invoiceItems[$itemIndex]['total'] = $this->invoiceItems[$itemIndex]['quantity'] * $price;
        $this->calculateSubTotal($itemIndex);
    }

    public function updateByTax($itemIndex, $tax)
    {
        $this->invoiceItems[$itemIndex]['gst_rate'] = $tax;
        // $this->invoiceItems[$itemIndex]['total'] = $this->invoiceItems[$itemIndex]['quantity'] * $price;
        $this->calculateSubTotal($itemIndex);
    }

    public function calculateSubTotal($itemIndex)
    {
        // price total  hsn_code gst_rate cgst_rate sgst_rate igst_rate taxable_price
        // convert all to floatval variables
        $price = floatval($this->invoiceItems[$itemIndex]['price']);
        $quantity = intval($this->invoiceItems[$itemIndex]['quantity']);
        $gst_rate = floatval($this->invoiceItems[$itemIndex]['gst_rate']);
        $cgst_rate = $gst_rate / 2;
        $sgst_rate = $gst_rate / 2;
        $igst_rate = $gst_rate;
        $taxable_price = floatval($this->invoiceItems[$itemIndex]['taxable_price']);

        // gst_amount = (taxable_price * (gst_rate /100))
        // price = taxable_price * gst_amount
        // total = price * quantity
        $gst_amount = ($taxable_price * ($gst_rate / 100));
        $price = $taxable_price + $gst_amount;
        $total = $price * $quantity;

        // again assign all to invoiceItems[itemIndex] using  standard_number_format() to convert floats
        $this->invoiceItems[$itemIndex]['price'] = standard_number_format($price);
        $this->invoiceItems[$itemIndex]['total'] = standard_number_format($total);
        $this->invoiceItems[$itemIndex]['gst_amount'] = standard_number_format($gst_amount);
        $this->invoiceItems[$itemIndex]['taxable_price'] = standard_number_format($taxable_price);
        $this->invoiceItems[$itemIndex]['gst_rate'] = standard_number_format($gst_rate);
        $this->invoiceItems[$itemIndex]['cgst_rate'] = standard_number_format($cgst_rate);
        $this->invoiceItems[$itemIndex]['sgst_rate'] = standard_number_format($sgst_rate);
        $this->invoiceItems[$itemIndex]['igst_rate'] = standard_number_format($igst_rate);
        $this->invoiceItems[$itemIndex]['taxable_price'] = standard_number_format($taxable_price);






        // $this->invoiceItems[$itemIndex]['total'] = $this->invoiceItems[$itemIndex]['quantity'] * $this->invoiceItems[$itemIndex]['price'];
    }

    private static $creatingRules = [
        'client_group_id' => ['required'],
        'client_id' => ['required'],
        'invoiceItems' => ['array'],
        'invoiceItems.*.id' => ['nullable', 'numeric'],
        'invoiceItems.*.name' => ['required', 'string', 'max:255'],
        'invoiceItems.*.description' => ['required', 'string', 'max:255'],
        'invoiceItems.*.quantity' => ['required', 'integer', 'min:1'],
        'invoiceItems.*.price' => ['required', 'numeric', 'min:0'],
        'invoiceItems.*.total' => ['required', 'numeric', 'min:0'],
        'invoiceItems.*.hsn_code' => ['nullable', 'string', 'max:255'],
        'invoiceItems.*.gst_rate' => ['nullable', 'numeric', 'min:0'],
        'invoiceItems.*.cgst_rate' => ['nullable', 'numeric', 'min:0'],
        'invoiceItems.*.sgst_rate' => ['nullable', 'numeric', 'min:0'],
        'invoiceItems.*.igst_rate' => ['nullable', 'numeric', 'min:0'],
        'invoiceItems.*.taxable_price' => ['required', 'numeric', 'min:0'],
        'invoiceItems.*.type' => ['required', 'string', 'in:product,service,task,other'],
        'invoiceItems.*.product_id' => ['requiredif:invoiceItems.*.type,product'],
        'invoiceItems.*.service_id' => ['requiredif:invoiceItems.*.type,service'],
        'invoiceItems.*.task_id' => ['requiredif:invoiceItems.*.type,task'],
    ];
    private static $creatingRuleAttributes = [
        'client_group_id' => 'Client Group',
        'client_id' => 'Client',
        'invoiceItems' => 'Invoice Items',
        'invoiceItems.*.id' => 'Invoice Item ID',
        'invoiceItems.*.name' => 'Item Name',
        'invoiceItems.*.description' => 'Item Description',
        'invoiceItems.*.quantity' => 'Item Quantity',
        'invoiceItems.*.price' => 'Item Price',
        'invoiceItems.*.total' => 'Item Total',
        'invoiceItems.*.hsn_code' => 'HSN Code',
        'invoiceItems.*.gst_rate' => 'GST Rate',
        'invoiceItems.*.cgst_rate' => 'CGST Rate',
        'invoiceItems.*.sgst_rate' => 'SGST Rate',
        'invoiceItems.*.igst_rate' => 'IGST Rate',
        'invoiceItems.*.taxable_price' => 'Taxable Price',
        'invoiceItems.*.type' => 'Item Type',
        'invoiceItems.*.product_id' => 'Product ID',
        'invoiceItems.*.service_id' => 'Service ID',
        'invoiceItems.*.task_id' => 'Task ID',
    ];

    public function createInvoice()
    {
        $invoiceItemsAll =  $this->validate(static::$creatingRules, null, static::$creatingRuleAttributes);
        $invoiceItems =  Arr::get($invoiceItemsAll, "invoiceItems");
        // ds($invoiceItems);
        $invItem = $this->getInvoiceItemsFromData($invoiceItems);
        // ds($invItem);
        // return;
        // foreach ($invItem as $key => $value) {
        //     # code...
        // }
        // try {
        //     // delete invoice items where in id in $delete_item_ids
        //     $this->invoice->items()->whereIn('id', $this->deleted_item_ids)->delete();
        // } catch (\Throwable $th) {
        //    report($th);
        //     //
        // }
        // return;
        OInvoice::CreateInvoiceM1(
            $this->client_group_id,
            $this->client_id,
            $invItem,
            $this->invoice_date,
            $this->due_date,
            $this->inv_type,
            $this->extra_inv_data,
        );

        // dispatch success alert
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Invoice Created!'
        ]);
        return redirect()->route('admin.invoices.index');
    }

    public function getInvoiceItemsFromData($data = [])
    {
        $invoiceItems = [];
        $invoiceItems = collect($data)->map(function ($item) {
            $is_taxable = $item['type'] === 'product' || $item['type'] === 'service' || $item['type'] === 'task';

            $tax_perc = 0;
            $discount = 0;
            $gst_rate = 0;
            $gst_amount = 0;
            $cgst_amount = 0;
            $sgst_amount = 0;
            $igst_amount = 0;
            $taxable_price = 0;
            $gst_rate = $tax_perc = floatval($item['gst_rate']);
            $gst_amount = floatval($item['taxable_price']) * ($tax_perc / 100);
            $cgst_amount = $gst_amount / 2;
            $sgst_amount = $gst_amount / 2;
            $igst_amount =   $gst_amount;
            $taxable_price = floatval($item['taxable_price']);
            $quantity = intval($item['quantity']);



            //subtotal =  taxable_price * quantity
            // gst_amount = (subtotal * (gst_rate /100))
            // total = subtotal + gst_amount

            $subtotal = ($taxable_price * $quantity) - $discount;
            $gst_amount = ($subtotal * ($gst_rate / 100));
            $total = $subtotal + $gst_amount;


            $sgst_amount =  $cgst_amount  = $gst_amount / 2;
            $igst_amount =   $gst_amount;


            // if ($item['gst_rate']) {
            //     $gst_rate = $tax_perc = floatval($item['gst_rate']);
            //     $gst_amount = floatval($item['taxable_price']) * ($tax_perc / 100);
            //     $cgst_amount = $gst_amount / 2;
            //     $sgst_amount = $gst_amount / 2;
            //     $igst_amount =   $gst_amount;
            // }


            // `invoiceable_type`, `invoiceable_id`

            $invoiceable_type = null;
            $invoiceable_id = null;
            // if type == product
            if ($item['type'] === 'product') {
                $invoiceable_type = Product::class;
                $invoiceable_id = $item['product_id'];
            }
            // if type == service
            if ($item['type'] === 'service') {
                $invoiceable_type = Service::class;
                $invoiceable_id = $item['service_id'];
            }
            // if type == task
            if ($item['type'] === 'task') {
                $invoiceable_type = Task::class;
                $invoiceable_id = $item['task_id'];
            }

            return [
                'id' => Arr::get($item, 'id', null),
                'name' => Arr::get($item, 'name'),
                'description' => Arr::get($item, 'description'),
                'price' => Arr::get($item, 'price'),
                'quantity' => Arr::get($item, 'quantity'),
                'is_taxable' => $is_taxable,
                'discount' => $discount,
                // 'subtotal' => Arr::get($item, 'price') * Arr::get($item, 'quantity'),
                // 'total' => Arr::get($item, 'total'),
                'type' => Arr::get($item, 'type'),
                'hsn_code' => Arr::get($item, 'hsn_code'),
                'tax_amount' => $gst_amount,
                'tax_perc' => $tax_perc,
                'gst_rate' => Arr::get($item, 'gst_rate'),
                'cgst_rate' => Arr::get($item, 'cgst_rate'),
                'sgst_rate' => Arr::get($item, 'sgst_rate'),
                'igst_rate' => Arr::get($item, 'igst_rate'),
                'taxable_price' => Arr::get($item, 'taxable_price'),
                'invoiceable_type' => $invoiceable_type,
                'invoiceable_id' => $invoiceable_id,

                'gst_amount' => $gst_amount,
                'cgst_amount' => $cgst_amount,
                'sgst_amount' => $sgst_amount,
                'igst_amount' => $igst_amount,
                'taxable_price' => $taxable_price,
                'subtotal' => $subtotal,
                'total' => $total,
                'extras' => json_encode([]),

                'additional' => null,
                'tax_infos' => json_encode([
                    'hsn_code' => Arr::get($item, 'hsn_code'),
                    'gst_rate' => Arr::get($item, 'gst_rate'),
                    'cgst_rate' => Arr::get($item, 'cgst_rate'),
                    'sgst_rate' => Arr::get($item, 'sgst_rate'),
                    'igst_rate' => Arr::get($item, 'igst_rate'),
                    'taxable_price' => Arr::get($item, 'taxable_price'),
                    'gst_amount' => $gst_amount,
                    'cgst_amount' => $cgst_amount,
                    'sgst_amount' => $sgst_amount,
                    'igst_amount' => $igst_amount,
                ]),
            ];
        })->toArray();
        return $invoiceItems;
    }


    public function updateInvoice()
    {
        $invoiceItemsAll =  $this->validate(static::$creatingRules, null, static::$creatingRuleAttributes);
        $invoice = OInvoice::find($this->invoice_id);
        $invoice->items()->whereIn('id', $this->deleted_item_ids)->delete();
        // dump($invoice->items()->whereIn('id', $this->deleted_item_ids)->delete());
        // return;
        // try {
        //     // delete invoice items where in id in $delete_item_ids
        //     $this->invoice->items()->whereIn('id', $this->deleted_item_ids)->delete();
        // } catch (\Throwable $th) {
        //    report($th);
        //     //
        // }
        $invoiceItems =  Arr::get($invoiceItemsAll, "invoiceItems");
        // dump($invoiceItems);
        $invItem = $this->getInvoiceItemsFromData($invoiceItems);
        // dump($invItem);
        // return;
        OInvoice::UpdateInvoiceM1(
            $invoice,
            $this->client_group_id,
            $this->client_id,
            $invItem,
            $this->invoice_date,
            $this->due_date,
            $this->inv_type,
            $this->extra_inv_data,
        );

        // dispatch success alert
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Invoice Updated!'
        ]);

        // return redirect()->route('admin.invoices.index');
    }
}
