<?php

namespace App\Http\Livewire\Admin\Invoices;

use App\Models\Circle;
use App\Models\CircleProductPivot;
use App\Models\Product;
use App\Models\User;
use Livewire\Component;

class Create extends Component
{
    public array $listsForFields = [];

    public CircleProductPivot $circleProductPivot;

    public function mount(CircleProductPivot $circleProductPivot)
    {
        $this->circleProductPivot           = $circleProductPivot;
        $this->circleProductPivot->quantity = '0';
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.admin.invoices.create');
    }

    public function submit()
    {
        $this->validate();

        $this->circleProductPivot->save();

        return redirect()->route('admin.circle-product-pivots.index');
    }

    protected function rules(): array
    {
        return [
            'circleProductPivot.product_id' => [
                'integer',
                'exists:products,id',
                'nullable',
            ],
            'circleProductPivot.circle_id' => [
                'integer',
                'exists:circles,id',
                'nullable',
            ],
            'circleProductPivot.quantity' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'circleProductPivot.price' => [
                'numeric',
                'nullable',
            ],
            'circleProductPivot.last_updated_by_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['product']         = Product::pluck('name', 'id')->toArray();
        $this->listsForFields['circle']          = Circle::pluck('name', 'id')->toArray();
        $this->listsForFields['last_updated_by'] = User::pluck('name', 'id')->toArray();
    }
}
