<?php

namespace App\Http\Controllers\ZonalOfficer;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Zone;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ZOMainController extends Controller
{


    public function myZones(Request $r)
    {
        // $user = User::getAuthUser();
        // $zones = $user->zones;
        $data = [
            // 'zones' => $zones,
        ];
        return view('zonal-officer.my-zones', $data);
    }


    public function zoneWiseProducts(Request $r, Zone $zone)
    {
        $user = User::getAuthUser();
        abort_if($user->zones()->where('id', $zone->id)->count() == 0, Response::HTTP_FORBIDDEN, '403 Forbidden');
        // $zones = $user->zones;
        $data = [
            'zone' => $zone,
        ];
        return view('zonal-officer.zone-wise-products', $data);
    }

    public function productRequests(Request $r, Zone $zone)
    {
        $user = User::getAuthUser();
        $zones = $user->zones;
        abort_if($user->zones()->where('id', $zone->id)->count() == 0, Response::HTTP_FORBIDDEN, '403 Forbidden');
        $data = [
            // 'zone' => null,
            'zone' => $zone,
            // 'zone' => $zone,
        ];
        return view('zonal-officer.product-requests', $data);
    }
}
