<?php

namespace App\Http\Controllers\Api\V1\App;

use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\AppNotification;
use App\Models\Service;
use App\Models\State;
use App\Models\District;
use App\Models\KVSetting;
use Illuminate\Support\Arr;

class AppController extends Controller
{




    public function maintenanceData(Request $request)
    {
        return [
            // 'enabled' => true,
            'enabled' => KVSetting::getAppIsMaintenance(),
            'message' => [
                'title' => 'App in maintenance mode',
                'body' => 'Please try after sometime',
                'btn' => '',
            ]
        ];
    }

    public function updateData(Request $request)
    {
        $av = KVSetting::getAppVersion();
        return [
            'version' => $av,
            'enabled' => KVSetting::getAppIsMaintenance(),
            'minorMandatory' => KVSetting::getAppVersionMinorMandatory(),
            // 'downloadUrl' => url('storage/peeasy.apk', [
            //     'v' => $av,
            //     'e' => 'download'
            // ]),
            // 'downloadUrl' => 'https://play.google.com/store/apps/details?id=in.payeasy.app',
            'downloadUrl' => route('app-download', [
                'v' => $av,
                'e' => 'download',
                'auto_download' => '1',
            ]),
            // 'version' => '1.2.20',
            // 'enabled' => true,
            "majorMessage" =>  [
                "title" => "Important App update",
                "body" => "Please update your app to the latest version to continue using it .",
                "btn" => "Download"
            ],
            "minorMessage" =>  [
                "title" => "App update available",
                "body" => "There's a new version available , would you like to get it now ?",
                "btn" => "Download"
            ]
        ];
    }

    public function otaUpdateData(Request $request)
    {
        $bi = $request->post("bi", []);
        $appFlavor  = Arr::get($bi, "flavor");
        $appOtaVersion  = Arr::get($bi, "otaVersion");
        $otaUpdateVersion = KVSetting::getOtaUpdateVersion();
        // $otaUpdateEnabledForProd = KVSetting::getOtaUpdateEnabledForProd();
        // if (($appFlavor == 'prod' &&  (!$otaUpdateEnabledForProd))) {
        //     $otaUpdateUrl = null;
        // } else {
        //     $otaUpdateUrl = KVSetting::getOtaUpdateUrl();
        // }
        $otaUpdateUrl = KVSetting::getOtaUpdateUrl();
        $dbOtaVersion = json_decode($otaUpdateVersion);
        $isUpdateNeeded = $this->isUpdateNeeded($appOtaVersion, $dbOtaVersion);
        return [
            'ota_resource_url' => $isUpdateNeeded ? json_decode($otaUpdateUrl) : false,
            'ota_version' =>  $dbOtaVersion,
        ];
    }

    public function getAppSettingsData(Request $request)
    {
        $otaUpdateUrl = KVSetting::getOtaUpdateUrl();
        $otaUpdateVersion = KVSetting::getOtaUpdateVersion();
        return [
            'ota_resource_url' => $otaUpdateUrl,
            'ota_version' => $otaUpdateVersion,
        ];
    }

    public function isUpdateNeeded($appVersion, $dbVersion)
    {
        $appVersion = explode('.', $appVersion);
        $dbVersion = explode('.', $dbVersion);
        if ($appVersion[0] < $dbVersion[0]) {
            return true;
        } else if ($appVersion[0] == $dbVersion[0] && $appVersion[1] < $dbVersion[1]) {
            return true;
        } else if ($appVersion[0] == $dbVersion[0] && $appVersion[1] == $dbVersion[1] && $appVersion[2] < $dbVersion[2]) {
            return true;
        } else {
            return false;
        }
    }
}
