<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreVisitRouteRequest;
use App\Http\Requests\UpdateVisitRouteRequest;
use App\Http\Resources\Admin\VisitRouteResource;
use App\Models\VisitRoute;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class VisitRouteApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('visit_route_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new VisitRouteResource(VisitRoute::with(['user', 'reimbursement'])->get());
    }

    public function store(StoreVisitRouteRequest $request)
    {
        $visitRoute = VisitRoute::create($request->validated());

        return (new VisitRouteResource($visitRoute))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(VisitRoute $visitRoute)
    {
        abort_if(Gate::denies('visit_route_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new VisitRouteResource($visitRoute->load(['user', 'reimbursement']));
    }

    public function update(UpdateVisitRouteRequest $request, VisitRoute $visitRoute)
    {
        $visitRoute->update($request->validated());

        return (new VisitRouteResource($visitRoute))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(VisitRoute $visitRoute)
    {
        abort_if(Gate::denies('visit_route_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $visitRoute->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
