<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreVisitReimbursementRequest;
use App\Http\Requests\UpdateVisitReimbursementRequest;
use App\Http\Resources\Admin\VisitReimbursementResource;
use App\Models\VisitReimbursement;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class VisitReimbursementApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('visit_reimbursement_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new VisitReimbursementResource(VisitReimbursement::with(['user', 'task', 'approvedBy', 'visit'])->get());
    }

    public function store(StoreVisitReimbursementRequest $request)
    {
        $visitReimbursement = VisitReimbursement::create($request->validated());

        return (new VisitReimbursementResource($visitReimbursement))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(VisitReimbursement $visitReimbursement)
    {
        abort_if(Gate::denies('visit_reimbursement_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new VisitReimbursementResource($visitReimbursement->load(['user', 'task', 'approvedBy', 'visit']));
    }

    public function update(UpdateVisitReimbursementRequest $request, VisitReimbursement $visitReimbursement)
    {
        $visitReimbursement->update($request->validated());

        return (new VisitReimbursementResource($visitReimbursement))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(VisitReimbursement $visitReimbursement)
    {
        abort_if(Gate::denies('visit_reimbursement_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $visitReimbursement->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
