<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreMonthlyPayslipRequest;
use App\Http\Requests\UpdateMonthlyPayslipRequest;
use App\Http\Resources\Admin\MonthlyPayslipResource;
use App\Models\MonthlyPayslip;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class MonthlyPayslipApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('monthly_payslip_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MonthlyPayslipResource(MonthlyPayslip::with(['finYr', 'user'])->get());
    }

    public function store(StoreMonthlyPayslipRequest $request)
    {
        $monthlyPayslip = MonthlyPayslip::create($request->validated());

        return (new MonthlyPayslipResource($monthlyPayslip))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(MonthlyPayslip $monthlyPayslip)
    {
        abort_if(Gate::denies('monthly_payslip_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MonthlyPayslipResource($monthlyPayslip->load(['finYr', 'user']));
    }

    public function update(UpdateMonthlyPayslipRequest $request, MonthlyPayslip $monthlyPayslip)
    {
        $monthlyPayslip->update($request->validated());

        return (new MonthlyPayslipResource($monthlyPayslip))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(MonthlyPayslip $monthlyPayslip)
    {
        abort_if(Gate::denies('monthly_payslip_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $monthlyPayslip->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
