<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreLedgerGroupRequest;
use App\Http\Requests\UpdateLedgerGroupRequest;
use App\Http\Resources\Admin\LedgerGroupResource;
use App\Models\LedgerGroup;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LedgerGroupApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('ledger_group_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new LedgerGroupResource(LedgerGroup::all());
    }

    public function store(StoreLedgerGroupRequest $request)
    {
        $ledgerGroup = LedgerGroup::create($request->validated());

        return (new LedgerGroupResource($ledgerGroup))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(LedgerGroup $ledgerGroup)
    {
        abort_if(Gate::denies('ledger_group_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new LedgerGroupResource($ledgerGroup);
    }

    public function update(UpdateLedgerGroupRequest $request, LedgerGroup $ledgerGroup)
    {
        $ledgerGroup->update($request->validated());

        return (new LedgerGroupResource($ledgerGroup))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(LedgerGroup $ledgerGroup)
    {
        abort_if(Gate::denies('ledger_group_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $ledgerGroup->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
