<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreJobDesignationRequest;
use App\Http\Requests\UpdateJobDesignationRequest;
use App\Http\Resources\Admin\JobDesignationResource;
use App\Models\JobDesignation;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class JobDesignationApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('job_designation_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new JobDesignationResource(JobDesignation::all());
    }

    public function store(StoreJobDesignationRequest $request)
    {
        $jobDesignation = JobDesignation::create($request->validated());

        return (new JobDesignationResource($jobDesignation))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(JobDesignation $jobDesignation)
    {
        abort_if(Gate::denies('job_designation_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new JobDesignationResource($jobDesignation);
    }

    public function update(UpdateJobDesignationRequest $request, JobDesignation $jobDesignation)
    {
        $jobDesignation->update($request->validated());

        return (new JobDesignationResource($jobDesignation))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(JobDesignation $jobDesignation)
    {
        abort_if(Gate::denies('job_designation_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $jobDesignation->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
