<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreFyRequest;
use App\Http\Requests\UpdateFyRequest;
use App\Http\Resources\Admin\FyResource;
use App\Models\Fy;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class FyApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('fy_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new FyResource(Fy::all());
    }

    public function store(StoreFyRequest $request)
    {
        $fy = Fy::create($request->validated());

        return (new FyResource($fy))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Fy $fy)
    {
        abort_if(Gate::denies('fy_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new FyResource($fy);
    }

    public function update(UpdateFyRequest $request, Fy $fy)
    {
        $fy->update($request->validated());

        return (new FyResource($fy))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Fy $fy)
    {
        abort_if(Gate::denies('fy_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $fy->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
