<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreFinYrRequest;
use App\Http\Requests\UpdateFinYrRequest;
use App\Http\Resources\Admin\FinYrResource;
use App\Models\FinYr;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class FinYrApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('fin_yr_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new FinYrResource(FinYr::all());
    }

    public function store(StoreFinYrRequest $request)
    {
        $finYr = FinYr::create($request->validated());

        return (new FinYrResource($finYr))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(FinYr $finYr)
    {
        abort_if(Gate::denies('fin_yr_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new FinYrResource($finYr);
    }

    public function update(UpdateFinYrRequest $request, FinYr $finYr)
    {
        $finYr->update($request->validated());

        return (new FinYrResource($finYr))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(FinYr $finYr)
    {
        abort_if(Gate::denies('fin_yr_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $finYr->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
