<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreEmployeeInfoRequest;
use App\Http\Requests\UpdateEmployeeInfoRequest;
use App\Http\Resources\Admin\EmployeeInfoResource;
use App\Models\EmployeeInfo;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class EmployeeInfoApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('employee_info_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new EmployeeInfoResource(EmployeeInfo::with(['user', 'jobDesgination'])->get());
    }

    public function store(StoreEmployeeInfoRequest $request)
    {
        $employeeInfo = EmployeeInfo::create($request->validated());

        return (new EmployeeInfoResource($employeeInfo))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(EmployeeInfo $employeeInfo)
    {
        abort_if(Gate::denies('employee_info_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new EmployeeInfoResource($employeeInfo->load(['user', 'jobDesgination']));
    }

    public function update(UpdateEmployeeInfoRequest $request, EmployeeInfo $employeeInfo)
    {
        $employeeInfo->update($request->validated());

        return (new EmployeeInfoResource($employeeInfo))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(EmployeeInfo $employeeInfo)
    {
        abort_if(Gate::denies('employee_info_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $employeeInfo->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
