<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreEmployeeFamilyDetailRequest;
use App\Http\Requests\UpdateEmployeeFamilyDetailRequest;
use App\Http\Resources\Admin\EmployeeFamilyDetailResource;
use App\Models\EmployeeFamilyDetail;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class EmployeeFamilyDetailApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('employee_family_detail_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new EmployeeFamilyDetailResource(EmployeeFamilyDetail::with(['employeeInfo'])->get());
    }

    public function store(StoreEmployeeFamilyDetailRequest $request)
    {
        $employeeFamilyDetail = EmployeeFamilyDetail::create($request->validated());

        return (new EmployeeFamilyDetailResource($employeeFamilyDetail))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(EmployeeFamilyDetail $employeeFamilyDetail)
    {
        abort_if(Gate::denies('employee_family_detail_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new EmployeeFamilyDetailResource($employeeFamilyDetail->load(['employeeInfo']));
    }

    public function update(UpdateEmployeeFamilyDetailRequest $request, EmployeeFamilyDetail $employeeFamilyDetail)
    {
        $employeeFamilyDetail->update($request->validated());

        return (new EmployeeFamilyDetailResource($employeeFamilyDetail))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(EmployeeFamilyDetail $employeeFamilyDetail)
    {
        abort_if(Gate::denies('employee_family_detail_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $employeeFamilyDetail->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
