<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreClientGroupRequest;
use App\Http\Requests\UpdateClientGroupRequest;
use App\Http\Resources\Admin\ClientGroupResource;
use App\Models\ClientGroup;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ClientGroupApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('client_group_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ClientGroupResource(ClientGroup::with(['zone', 'state', 'circle'])->get());
    }

    public function store(StoreClientGroupRequest $request)
    {
        $clientGroup = ClientGroup::create($request->validated());
        $clientGroup->zone()->sync($request->input('zone', []));
        $clientGroup->state()->sync($request->input('state', []));
        $clientGroup->circle()->sync($request->input('circle', []));

        return (new ClientGroupResource($clientGroup))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(ClientGroup $clientGroup)
    {
        abort_if(Gate::denies('client_group_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ClientGroupResource($clientGroup->load(['zone', 'state', 'circle']));
    }

    public function update(UpdateClientGroupRequest $request, ClientGroup $clientGroup)
    {
        $clientGroup->update($request->validated());
        $clientGroup->zone()->sync($request->input('zone', []));
        $clientGroup->state()->sync($request->input('state', []));
        $clientGroup->circle()->sync($request->input('circle', []));

        return (new ClientGroupResource($clientGroup))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(ClientGroup $clientGroup)
    {
        abort_if(Gate::denies('client_group_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $clientGroup->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
