<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\VisitRoute;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class VisitRouteController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('visit_route_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.visit-route.index');
    }

    public function create()
    {
        abort_if(Gate::denies('visit_route_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.visit-route.create');
    }

    public function edit(VisitRoute $visitRoute)
    {
        abort_if(Gate::denies('visit_route_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.visit-route.edit', compact('visitRoute'));
    }

    public function show(VisitRoute $visitRoute)
    {
        abort_if(Gate::denies('visit_route_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $visitRoute->load('user', 'reimbursement');

        return view('admin.visit-route.show', compact('visitRoute'));
    }
}
