<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Livewire\Admin\VisitReimbursement\Reports\EmployeeWiseTaReport;
use App\Models\VisitReimbursement;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Barryvdh\DomPDF\Facade\Pdf as BarryPDF;

class VisitReimbursementController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('visit_reimbursement_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.visit-reimbursement.index');
    }

    public function create()
    {
        abort_if(Gate::denies('visit_reimbursement_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.visit-reimbursement.create');
    }

    public function edit(VisitReimbursement $visitReimbursement)
    {
        abort_if(Gate::denies('visit_reimbursement_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.visit-reimbursement.edit', compact('visitReimbursement'));
    }

    public function show(VisitReimbursement $visitReimbursement)
    {
        abort_if(Gate::denies('visit_reimbursement_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $visitReimbursement->load('user', 'task', 'approvedBy', 'visit');

        return view('admin.visit-reimbursement.show', compact('visitReimbursement'));
    }

    public function EmployeeWiseTaReport()
    {
        $data = [];
        return view('admin.visit-reimbursement.report.employee-wise-ta-report', $data);
    }
    public function EmployeeWiseTaReportExport(Request $request, EmployeeWiseTaReport $employeeWiseTaReport)
    {
        $user = $request->user();
        abort_unless($user && $user->isAdmin(), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $engineer = $request->get('s[engineer]');
        $year_month = $request->get('s[year_month]');
        $range = $request->get('s[range]');
        $state001 = $request->get('s');
        $export = $request->get('e', 'html');

        // // $monthlyAttendanceExportReport->setMonth($month);
        // // $monthlyAttendanceExportReport->setYear($year);
        // $employeeWiseTaReport->fill([
        //     'state.month' => $month,
        //     'state.year' => $year,
        // ]);
        $employeeWiseTaReport->fill([
            'state' => $state001,
        ]);

        // dd($state001);
        $data = $employeeWiseTaReport->getDataForExternal($engineer, $year_month, $range);
        // $monthlyAttendanceExportReport->mount();
        // $html =  $monthlyAttendanceExportReport
        //     ->render()
        //     // ->renderToView()
        //     // ->output()s
        //     //
        // ;

        if ($export == 'pdf') {
            $pdf = BarryPDF::loadView('prints.employee-wise-ta-report-v1', $data)->setOptions([
                'defaultFont' => 'sans-serif',
                'isHtml5ParserEnabled' => true,
                "enable_php" => true,
                "isRemoteEnabled" => true,
            ])
                ->setPaper('a4', 'potrait')
                // ->setPaper('a4', 'landscape')
                //
            ;
            return $pdf->stream();
        } else {
            return view('prints.employee-wise-ta-report-v1', $data);
        }
    }
}
