<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Task;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class TaskController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('task_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.task.index');
    }

    public function create()
    {
        abort_if(Gate::denies('task_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.task.create');
    }

    public function edit(Task $task)
    {
        abort_if(Gate::denies('task_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.task.edit', compact('task'));
    }

    public function show(Task $task)
    {
        abort_if(Gate::denies('task_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');

        return view('admin.task.show', compact('task'));
    }

    public function storeMedia(Request $request)
    {
        abort_if(Gate::none(['task_create', 'task_edit']), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->has('size')) {
            $this->validate($request, [
                'file' => 'max:' . $request->input('size') * 1024,
            ]);
        }

        $model                     = new Task();
        $model->id                 = $request->input('model_id', 0);
        $model->exists             = true;
        $media                     = $model->addMediaFromRequest('file')->toMediaCollection($request->input('collection_name'));
        $media->wasRecentlyCreated = true;

        return response()->json(compact('media'), Response::HTTP_CREATED);
    }


    public function engTasks()
    {
        return view('engineer.task.index');

    }


    public function engShow(Task $task)
    {
        // abort_if(Gate::denies('task_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');

        return view('engineer.task.show', compact('task'));
    }
    public function clientTasks()
    {
        return view('client.task.index');

    }


    public function clientTaskCreate()
    {
        // abort_if(Gate::denies('task_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('client.task.create');
    }


    public function clientShow(Task $task)
    {
        // abort_if(Gate::denies('task_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');

        return view('client.task.show', compact('task'));
    }



    public function circleOfficerTasks()
    {
        return view('circle-officer.task.index');

    }


    public function circleOfficerTaskCreate()
    {
        // abort_if(Gate::denies('task_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('circle-officer.task.create');
    }


    public function circleOfficerShow(Task $task)
    {
        // abort_if(Gate::denies('task_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');

        return view('circle-officer.task.show', compact('task'));
    }

    public function circleOfficerEdit(Task $task)
    {
        // abort_if(Gate::denies('task_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('circle-officer.task.edit', compact('task'));
    }


    public function zonalOfficerTasks()
    {
        return view('zonal-officer.task.index');

    }


    public function zonalOfficerTaskCreate()
    {
        // abort_if(Gate::denies('task_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('zonal-officer.task.create');
    }


    public function zonalOfficerShow(Task $task)
    {
        // abort_if(Gate::denies('task_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');

        return view('zonal-officer.task.show', compact('task'));
    }

    public function zonalOfficerEdit(Task $task)
    {
        // abort_if(Gate::denies('task_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('zonal-officer.task.edit', compact('task'));
    }


}
