<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\State;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class StateController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = State::class;
    }

    public function index()
    {
        abort_if(Gate::denies('state_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.state.index');
    }

    public function create()
    {
        abort_if(Gate::denies('state_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.state.create');
    }

    public function edit(State $state)
    {
        abort_if(Gate::denies('state_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.state.edit', compact('state'));
    }

    public function show(State $state)
    {
        abort_if(Gate::denies('state_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $state->load(/* 'zone', */'region');

        return view('admin.state.show', compact('state'));
    }
}
