<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ProductTaskEventLog;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ProductTaskEventLogController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('product_task_event_log_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.product-task-event-log.index');
    }

    public function create()
    {
        abort_if(Gate::denies('product_task_event_log_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.product-task-event-log.create');
    }

    public function edit(ProductTaskEventLog $productTaskEventLog)
    {
        abort_if(Gate::denies('product_task_event_log_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.product-task-event-log.edit', compact('productTaskEventLog'));
    }

    public function show(ProductTaskEventLog $productTaskEventLog)
    {
        abort_if(Gate::denies('product_task_event_log_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $productTaskEventLog->load('taskEventLog', 'product', 'approvedBy');

        return view('admin.product-task-event-log.show', compact('productTaskEventLog'));
    }
}
