<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MonthlyPayslip;
use App\Models\User;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use Barryvdh\DomPDF\Facade\Pdf as BarryPDF;

class MonthlyPayslipController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('monthly_payslip_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.monthly-payslip.index');
    }

    public function create()
    {
        abort_if(Gate::denies('monthly_payslip_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.monthly-payslip.create');
    }

    public function edit(MonthlyPayslip $monthlyPayslip)
    {
        abort_if(Gate::denies('monthly_payslip_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.monthly-payslip.edit', compact('monthlyPayslip'));
    }

    public function show(MonthlyPayslip $monthlyPayslip)
    {
        abort_if(Gate::denies('monthly_payslip_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $monthlyPayslip->load('finYr', 'user');

        return view('admin.monthly-payslip.show', compact('monthlyPayslip'));
    }

    public function export(User $user, MonthlyPayslip $payslip)
    {
        if ($user->id != $payslip->user_id) {
            abort(404);
        }
        $request = request();
        $mode = $request->get('mode', 'pdf');

        $_get = function ($key) use ($payslip) {
            return $payslip->$key;
        };

        $data = compact('payslip', 'user', '_get');

        // return $pdf->download('invoice.pdf');
        if ($mode == 'pdf') {
            $pdf = BarryPDF::loadView('prints.payslip-v1', $data);
            return $pdf->stream();
        } else {

            return view('prints.payslip-v1', $data);
        }
    }
}
