<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LedgerTransaction;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LedgerTransactionController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('ledger_transaction_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-transaction.index');
    }

    public function create()
    {
        abort_if(Gate::denies('ledger_transaction_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-transaction.create');
    }

    public function edit(LedgerTransaction $ledgerTransaction)
    {
        abort_if(Gate::denies('ledger_transaction_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-transaction.edit', compact('ledgerTransaction'));
    }

    public function show(LedgerTransaction $ledgerTransaction)
    {
        abort_if(Gate::denies('ledger_transaction_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $ledgerTransaction->load('finYr', 'ledger');

        return view('admin.ledger-transaction.show', compact('ledgerTransaction'));
    }
}
